$(document).ready(function(){
	getStockData();
    getBarcodeData();
});
function getStockData(){
    var editUrl = $('#editUrl').val();
    var viewUrl = $('#viewUrl').val();
    var uid = $('#uid').val();
    var u_roll_id = $('#u_roll_id').val();
    var requestEditUrl = $('#requestEditUrl').val();
    var requestViewUrl = $('#requestViewUrl').val();
    var base_url = $('#base_url').val();
    var st_cat_id = $('#st_cat_id').val();
	if($('.datastock').length > 0) {
        if(st_cat_id == 4){

            var table = $('.datastock').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "searching": true,
            "paging": true,
            "pageLength": 500, 
            "lengthMenu": [5, 10, 25, 50, 100, 200],  
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": base_url+"stock/get/"+st_cat_id, 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
            
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<label class="checkboxs">
                            <input type="checkbox" id="${row.s_id}" class="selected-stock-row">
                            <span class="checkmarks"></span>
                        </label>`;
            }
        },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<a href='`+requestViewUrl+`/${row.s_id}'>
                            <u>${row.title}</u>  
                          </a>`;
          }
        },
        { "data": "generated_by" },
         { "data": "created" },
        
        { "data": "flycondition" },
        { "data": "pi_email" },
       
        {
          "data": null, 
          "render": function (data, type, row) {

             // if(row.is_active == 0){
             //    return `<div class='edit-delete-action'>
             //              <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+requestViewUrl+`/${row.s_id}'>
             //                  <i data-feather='view' class='feather-eye'></i>
             //              </a>
             //              <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteStock(${row.s_id})' href='javascript:void(0);'>
             //                  <i data-feather='trash-2' class='feather-trash-2'></i>
             //              </a>
             //              <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+requestEditUrl+`/${row.s_id}'>
             //                  <i data-feather='edit' class='feather-edit'></i>
             //              </a>
             //              <a class='me-2 btn btn-success' onclick="acceptStock(${row.s_id},1)">
             //                  Accept
             //              </a>
             //          </div>`;
             // } else {
                if(u_roll_id == 6){ 
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+requestViewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+requestEditUrl+`/${row.s_id}'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteStock(${row.s_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
               } else {
                 if(row.stock_handled_by == uid && u_roll_id == 5){  

                    return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+requestViewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+requestEditUrl+`/${row.s_id}'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteStock(${row.s_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;

                 } else {


                    return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+requestViewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                          
                      </div>`;

                    

                 }

               }       
             // }
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });

        }else{

            var table = $('.datastock').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "searching": true,
            "paging": true,
            "pageLength": 500, 
            "lengthMenu": [5, 10, 25, 50, 100, 200],  
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": base_url+"stock/get/"+st_cat_id, 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
            
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<label class="checkboxs">
                            <input type="checkbox" id="${row.s_id}" class="selected-stock-row">
                            <span class="checkmarks"></span>
                        </label>`;
            }
        },
        { "data": "category" },
        { "data": "ncbs_id" },
        { "data": "old_ncbs_id" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<a href='`+viewUrl+`/${row.s_id}'>
                            <u>${row.title}</u>  
                          </a>`;
          }
        },
        { "data": "phenotype" },
        { "data": "uname" },
        { "data": "gname" },
        { "data": "availability" },
        { "data": "flycondition" },
        { "data": "created" },
        {
          "data": null, 
          "render": function (data, type, row) {
             if(u_roll_id == 6){ 
             if(row.is_active == 0 && st_cat_id == 3){
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+viewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteStock(${row.s_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+editUrl+`/${row.s_id}'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 btn btn-success' onclick="acceptStock(${row.s_id},1)">
                              Accept
                          </a>
                      </div>`;
             } else {
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+viewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+editUrl+`/${row.s_id}'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteStock(${row.s_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
             } } else { 
             if(row.stock_handled_by == uid && u_roll_id == 5){    
             if(row.is_active == 0 && st_cat_id == 3){
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+viewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteStock(${row.s_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+editUrl+`/${row.s_id}'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 btn btn-success' onclick="acceptStock(${row.s_id},1)">
                              Accept
                          </a>
                      </div>`;
             } else {
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+viewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+editUrl+`/${row.s_id}'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.s_id}' onclick='deleteStock(${row.s_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
             } } else { 
                if(row.is_active == 0 && st_cat_id == 3){
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+viewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                        
                      </div>`;
             } else {
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.s_id}' href='`+viewUrl+`/${row.s_id}'>
                              <i data-feather='view' class='feather-eye'></i>
                          </a>
                         
                      </div>`;
             }


             } }
             
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });


        }
	
        $('#category_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[1] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#uname_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[6] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#flycondition_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[9] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#availability_filter').on('change', function() {
            var selectedValue = $(this).val();
            table.search('').draw();
            if (selectedValue) {
                $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                    return data[8] === selectedValue; 
                });
                table.draw();
            } else {
               $.fn.dataTable.ext.search.pop();
                table.draw();
            }
        });
        $('#date_filter').on('change', function() {
            var order_date = $(this).val(); 
            $.ajax({
                type: "POST",
                url: base_url+"order/orderDate",
                data: {order_date: order_date},
                dataType: 'json',
                success: function(data) { 
                    var selectedValue = data;
                    table.search('').draw();
                    if (selectedValue) {
                        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                            return data[10] === selectedValue; 
                        });
                        table.draw();
                    } else {
                       $.fn.dataTable.ext.search.pop();
                        table.draw();
                    }
                },
                error: function(xhr, status, error) {
                    $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
                }
            });
        });
	}
}

function acceptStock(s_id,is_active){ 
    var s_id = s_id;
    var is_active = is_active; 
    var base_url = $('#base_url').val();
    $.ajax({
            type: "POST",
            url: base_url+"stock/acceptStock",
            data: {s_id:s_id, is_active:is_active},
            success: function(data) { 
                 $('#stock_status_success').removeClass('d-none');
                    setTimeout(function(){
                        $('#stock_status_success').addClass('d-none');
                        var table = $('.datastock').DataTable();
                        table.ajax.reload();
                    }, 2000);   
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$('#bulk-view').on('click', function() {
    var checkedIds = $('.selected-stock-row:checked').map(function() {
        return this.id;
    }).get();
    var base_url = $('#base_url').val();
    $.ajax({
            type: "POST",
            url: base_url+'stock/bulk-view',
            data: {'s_id' : checkedIds},
            success: function(data) {
                var output = JSON.parse(data);
                for(var i = 0; i < output.length; i++){
                    if(output[i].gname == undefined){
                        output[i].gname = '';
                    }
                    $('#stock-bulk-view').append(`<table class="table table-responsive"><thead><tr><td></td><td><b>Stock - `+output[i].title+` details</b></td><td></td><td></td></tr></thead><tbody>`+
                                                `<tr><td>Stock Category</td><td>`+output[i].category+`</td></tr>`+
                                                `<tr><td>NCBS Id</td><td>`+output[i].ncbs_id+`</td><td>Title</td><td>`+output[i].title+`</td></tr>`+
                                                `<tr><td>Barcode</td><td>`+output[i].barcode+`</td><td>Old NCBS Id</td><td>`+output[i].old_ncbs_id+`</td></tr>`+
                                                `<tr><td>Genotype</td><td>`+output[i].genotype+`</td><td>CG Number</td><td>`+output[i].cg_number+`</td></tr>`+
                                                `<tr><td>Visible Markers</td><td>`+output[i].visible_markers+`</td><td>Obtained By</td><td>`+output[i].obtained_by+`</td></tr>`+
                                                `<tr><td>Generated By</td><td>`+output[i].generated_by+`</td><td>Phenotype</td><td>`+output[i].phenotype+`</td></tr>`+
                                                `<tr><td>Publications</td><td>`+output[i].publications+`</td><td>Choromosome Affected</td><td>`+output[i].choromosome_affected+`</td></tr>`+
                                                `<tr><td>Fly base link</td><td>`+output[i].fly_base_link+`</td><td>Price</td><td>`+output[i].price+`</td></tr>`+
                                                `<tr><td>Fly condition</td><td>`+output[i].flycondition+`</td><td>Availability</td><td>`+output[i].availability+`</td></tr>`+
                                                `<tr><td>PI Name</td><td>`+output[i].uname+`</td><td>Group Name</td><td>`+output[i].gname+`</td></tr>`+
                                                `<tr><td>Sort Order</td><td>`+output[i].sort_order+`</td><td>Comment</td><td>`+output[i].comment+`</td></tr>`+
                                                `</tbody></table>`);
                }
                $('#bulk-stock-view').modal('show');
            },
            error: function(xhr, status, error) {
                $('#stock_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
    });
});

$('#bulk-download').on('click', function() {
    var checkedIds = $('.selected-stock-row:checked').map(function() {
        return this.id;
    }).get();

    if (checkedIds.length > 0) {
        var base_url = $('#base_url').val();
        var form = $('<form>', {
            method: 'POST',
            action: base_url + 'stock/bulk-download'
        });
        $('<input>', {
            type: 'hidden',
            name: 's_id',
            value: JSON.stringify(checkedIds) 
        }).appendTo(form);

        $(document.body).append(form);
        form.submit();
        form.remove(); 
    } else {
        alert('Please select at least one item.');
    }
});


$('#bulk-delete').on('click', function() {
    var checkedIds = $('.selected-stock-row:checked').map(function() {
        return this.id;
    }).get();
    if(checkedIds == ''){
        Swal.fire({
            icon: "danger",
            title: "Stock",
            text: "Choose stock!",
            confirmButtonClass: "btn btn-danger",
          });
    } else {
        var base_url = $('#base_url').val();
        Swal.fire({
            title: "Are you sure you want to delete all this stock?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!",
            confirmButtonClass: "btn btn-success",
            cancelButtonClass: "btn btn-danger ml-1",
            buttonsStyling: false,
          }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: base_url+'stock/bulk-delete',
                    data: {'s_id' : checkedIds},
                    success: function(data) {
                        Swal.fire({
                                    icon: "success",
                                    title: "Deleted!",
                                    text: "Stock details has been deleted.",
                                    confirmButtonClass: "btn btn-success",
                                  });
                                var table = $('.datastock').DataTable();
                                table.ajax.reload();               
                    },
                    error: function(xhr, status, error) {
                        alert('An error occurred: ' + error);
                    }
                });
            }
          });
    }
});

$("#bulk_edit_form").submit(function(event) {
    event.preventDefault(); 

    var form = $(this);
    var actionUrl = form.attr('action');
    var formData = new FormData(form[0]); 
    $.ajax({
        type: "POST",
        url: actionUrl,
        data: formData,
        contentType: false, 
        processData: false, 
        success: function(data) { 
            $('#stockupload_save_success').removeClass('d-none');
            $('#stockupload_save_error').addClass('d-none');
            window.location.reload();
        },
        error: function(xhr, status, error) {
            $('#stockupload_save_success').addClass('d-none');
            $('#stockupload_save_error').removeClass('d-none');
        }
    });
});

$("#stock_edit_form").submit(function(e) {
    e.preventDefault(); // Prevent default form submission

    var ncbs_id = $('#ncbs_id').val();
    var title = $('#title').val(); 
    var barcode = $('#barcode').val();
    var genotype = $('#genotype').val();
    var availability = $('#availability').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (ncbs_id.trim() === '') {
        $('#ncbs_id').addClass('is-invalid');
        $('#ncbs_id_error').removeClass('d-none');
        isValid = false;
    }

    if (title.trim() === '') {
        $('#title').addClass('is-invalid');
        $('#title_error').removeClass('d-none');
        isValid = false;
    }

    if (barcode.trim() === '') {
        $('#barcode').addClass('is-invalid');
        $('#barcode_error').removeClass('d-none');
        isValid = false;
    }

    if (genotype.trim() === '') {
        $('#genotype').addClass('is-invalid');
        $('#genotype_error').removeClass('d-none');
        isValid = false;
    }

    if (availability.trim() === '') {
        $('#availability').addClass('is-invalid');
        $('#availability_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) {
                $('#stock_save_error').addClass('d-none');
                $('#stock_save_success').removeClass('d-none');
                setTimeout(function(){     
                    window.location.reload();
                    $('#stock_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stock_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stock_save_error').removeClass('d-none');
        $('#stock_save_success').addClass('d-none');
    }
});

$("#stock_form").submit(function(e) {
    e.preventDefault(); 

    var ncbs_id = $('#ncbs_id').val();
    var title = $('#title').val();
    var barcode = $('#barcode').val();
    var genotype = $('#genotype').val();
    var availability = $('#availability').val();
    var st_cat_id = $('#st_cat_id').val();
    var fly_condition = $('#fly_condition').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');

     if (st_cat_id.trim() === '') {
        $('#st_cat_id').addClass('is-invalid');
        $('#st_cat_id_error').removeClass('d-none');
        isValid = false;
    }

     if (fly_condition.trim() === '') {
        $('#fly_condition').addClass('is-invalid');
        $('#fly_condition_error').removeClass('d-none');
        isValid = false;
    }
    
    if (ncbs_id.trim() === '') {
        $('#ncbs_id').addClass('is-invalid');
        $('#ncbs_id_error').removeClass('d-none');
        isValid = false;
    }

    if (title.trim() === '') {
        $('#title').addClass('is-invalid');
        $('#title_error').removeClass('d-none');
        isValid = false;
    }

    if (barcode.trim() === '') {
        $('#barcode').addClass('is-invalid');
        $('#barcode_error').removeClass('d-none');
        isValid = false;
    }

    if (genotype.trim() === '') {
        $('#genotype').addClass('is-invalid');
        $('#genotype_error').removeClass('d-none');
        isValid = false;
    }

    if (availability.trim() === '') {
        $('#availability').addClass('is-invalid');
        $('#availability_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            dataType: 'json',
            data: form.serialize(),
            success: function(data) {

                 console.log(data);
                if(data == 'duplicate'){
                     
                     duplicateStockAlert();
                 }else if(data == 'success'){
                $('#stock_save_error').addClass('d-none');
                $('#stock_save_success').removeClass('d-none');
                addStockSuccessAlert();
                setTimeout(function(){     
                    $('#stock_form')[0].reset();
                    $('#st_cat_id').val(0).trigger('change');
                    $('#fly_condition').val(0).trigger('change');
                    $('#pi_id').val(0).trigger('change');
                    $('#barcode_img').remove();
                    $('#barcode').val(0);
                    $('#generatebtn').removeClass('d-none');
                    $('#stock_save_success').addClass('d-none');
                    $('.barcode_data').html('<svg id="barcode_img"></svg>');
                }, 2000);
             }
            },
            error: function(xhr, status, error) {
                $('#stock_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stock_save_error').removeClass('d-none');
        $('#stock_save_success').addClass('d-none');
    }
});

function deleteStock(s_id){
	var s_id = s_id;
	Swal.fire({
    title: "Are you sure you want to delete this stock?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
    	$.ajax({
            type: "POST",
            url: "delete", 
            data: {s_id:s_id},
            success: function(data) {
                Swal.fire({
					        icon: "success",
					        title: "Deleted!",
					        text: "Stock details has been deleted.",
					        confirmButtonClass: "btn btn-success",
					      });
								var table = $('.datastock').DataTable();
								table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}

$("#bulk_upload_form").submit(function(event) {
    var upload = $('#upload').val();
    if(upload == ''){
        event.preventDefault(); 
        Swal.fire({
            icon: "Danger",
            title: "Bulk upload!",
            text: "Please attach the excel!",
            confirmButtonClass: "btn btn-danger",
          });
    } else {
        event.preventDefault(); 

        var form = $(this);
        var actionUrl = form.attr('action');
        var formData = new FormData(form[0]); 

        $.ajax({
            type: "POST",
            url: actionUrl,
            data: formData,
            dataType: 'json',
            contentType: false, 
            processData: false, 
            success: function(data) {
                // console.log(data);
                if(data == 'success'){
                $('#bulk_upload_form')[0].reset();
                $('#stockupload_save_success').removeClass('d-none');
                $('#stockupload_save_error').addClass('d-none');
                setTimeout(function(){     
                    $('#stockupload_save_success').addClass('d-none');
                }, 2000);
                window.location.reload();
              }else{
                 
                $('#stockupload_save_success').addClass('d-none');
                $('#stockupload_save_error').removeClass('d-none');
                window.location.reload();

              }
            },
            error: function(xhr, status, error) {
                $('#stockupload_save_success').addClass('d-none');
                $('#stockupload_save_error').removeClass('d-none');
            }
        });
    }
});

$(document).on('click', '#searchResult div', function() {
    var search = $(this).text();
    $('#productSearch').val(search);
    $('#searchResult').empty().hide();
    $.ajax({
        type: "POST",
        url: "searchStock", 
        data: {search:search},
        dataType: 'json',
        success: function(data) {
            $('#dataBarcodenew').append(`<tr id="row-`+data.s_id+`">`+
                                        `<td>`+data.fly_stock_name+`</td>`+
                                        `<td>`+data.genotype+`</td>`+
                                        `<td>`+data.obtained_by+`</td>`+
                                        `<td>`+data.group_name+`</td>`+
                                        `<td class="action-table-data justify-content-center">`+
                                            `<div class="edit-delete-action">`+
                                                `<a class="confirm-text barcode-delete-icon" id="`+data.s_id+`" onclick="removeStock(`+data.s_id+`)">`+
                                                    `<i data-feather="trash-2" class="feather-trash-2"></i>`+
                                                `</a>`+
                                            `</div>`+
                                        `</td>`+
                                    `</tr>`); 
        },
        error: function(xhr, status, error) {
            alert('An error occurred: ' + error);
        }
    });
});

$(document).click(function(event) {
    if (!$(event.target).closest('#productSearch').length) {
        $('#searchResult').empty().hide();
    }
});

function removeStock(s_id){
   $('#row-' + s_id).remove(); 
}

function generateBarcode(){
    const rowIds = [];
    $('#stocklistData tbody tr td div a').each(function() {
        const rowId = $(this).attr('id');
        if (rowId) {
            var scode = rowId;
            rowIds.push(rowId);
        }
    });
    const code = rowIds;
    if(code == ''){
        Swal.fire({
            icon: "danger",
            title: "Barcode!",
            text: "Choose stock!",
            confirmButtonClass: "btn btn-danger",
          });
    } else {
        $.ajax({
            type: "POST",
            url: "saveBarcode", 
            data: { code : code},
            success: function(data) { 
                JsBarcode("#barcode", code, {
                    format: "CODE128", // You can change the format here
                    width: 2,
                    height: 40,
                    displayValue: true
                }); 
                $('#prints-barcode').modal('show');
                $('#dataBarcodenew').html('');
                $('#barcode_save_success').removeClass('d-none');
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
}

function getBarcodeData(){
    if($('.dataBarcode').length > 0) {
    $('.dataBarcode').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
          "url": "barcode/get", 
          "type": "GET", 
          "dataSrc": "" 
            },
            "columns": [
                { "data": "b_id" },
                { 
                  "data": "barcode",
                  "render": function(data, type, row) {
                      return `<svg class='barcode-display' id='barcode-${row.b_id}'></svg>`;
                  }
                },
                {
                  "data": null, 
                  "render": function (data, type, row) {
                      return `<div class='edit-delete-action'>
                                  <a class='me-2 p-2 mb-0' id='delete-btn-${row.b_id}' onclick='deleteBarcode(${row.b_id})' href='javascript:void(0);'>
                                      <i data-feather='trash-2' class='feather-trash-2'></i>
                                  </a>
                              </div>`;
                  },
                  "createdCell": function (td, cellData, rowData, row, col) {
                      $(td).addClass('action-table-data');
                  }
                }
            ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },
            drawCallback: function() {
                const api = this.api();
                api.rows().every(function() {
                    const data = this.data();
                    JsBarcode(`#barcode-${data.b_id}`, data.barcode, {
                        format: "CODE128",
                        width: 2,
                        height: 40,
                        displayValue: true
                    });
                });
            } 
        });
    }
     
}

function addStockSuccessAlert(){
   
    Swal.fire({
    title: "Form submitted successfully!",
    text: "Stock is Added!",
    icon: "success",
    showCancelButton: false,
    buttonsStyling: true,
  })
}

function duplicateStockAlert(){
   
    Swal.fire({
    title: "Form is not submitted!",
    text: "Stock with similar ncbs id already there!",
    icon: "warning",
    showCancelButton: false,
    buttonsStyling: true,
  })
}

function deleteBarcode(b_id){
    var b_id = b_id;
    Swal.fire({
    title: "Are you sure you want to delete this Barcode?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
        $.ajax({
            type: "POST",
            url: "barcode/delete", 
            data: {b_id:b_id},
            success: function(data) {
                Swal.fire({
                            icon: "success",
                            title: "Deleted!",
                            text: "Barcode details has been deleted.",
                            confirmButtonClass: "btn btn-success",
                          });
                var table = $('.dataBarcode').DataTable();
                table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}

$("#stock_request_form").submit(function(e) {
    e.preventDefault(); 

    var genotype = $('#genotype').val();
    var title = $('#title').val();
    var fly_condition = $('#fly_condition').val();
    var generated_by = $('#generated_by').val();
    var gene_affected = $('#gene_affected').val();
    var pi_email = $('#pi_email').val();
    var requested_fly_status = $('#requested_fly_status').val();
    
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (genotype.trim() === '') {
        $('#genotype').addClass('is-invalid');
        $('#genotype_error').removeClass('d-none');
        isValid = false;
    }

    if (title.trim() === '') {
        $('#title').addClass('is-invalid');
        $('#title_error').removeClass('d-none');
        isValid = false;
    }

    if (fly_condition.trim() === '') {
        $('#fly_condition').addClass('is-invalid');
        $('#fly_condition_error').removeClass('d-none');
        isValid = false;
    }

    //  if (requested_fly_status.trim() === '') {
    //     $('#requested_fly_status').addClass('is-invalid');
    //     $('#requested_fly_status_error').removeClass('d-none');
    //     isValid = false;
    // }

    if (generated_by.trim() === '') {
        $('#generated_by').addClass('is-invalid');
        $('#generated_by_error').removeClass('d-none');
        isValid = false;
    }

    if (gene_affected.trim() === '') {
        $('#gene_affected').addClass('is-invalid');
        $('#gene_affected_error').removeClass('d-none');
        isValid = false;
    }

    if (pi_email.trim() === '') {
        $('#pi_email').addClass('is-invalid');
        $('#pi_email_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) {
                $('#stock_save_error').addClass('d-none');
                $('#stock_save_success').removeClass('d-none');
                setTimeout(function(){     
                    $('#stock_form')[0].reset();
                    $('#st_cat_id').val(0);
                    $('#stock_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stock_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stock_save_error').removeClass('d-none');
        $('#stock_save_success').addClass('d-none');
    }
});


$("#stock_edit_request_form").submit(function(e) {
    e.preventDefault(); // Prevent default form submission

     var genotype = $('#genotype').val();
    var title = $('#title').val();
    var fly_condition = $('#fly_condition').val();
    var generated_by = $('#generated_by').val();
    var gene_affected = $('#gene_affected').val();
    var pi_email = $('#pi_email').val();
    var requested_fly_status = $('#requested_fly_status').val();
    
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (genotype.trim() === '') {
        $('#genotype').addClass('is-invalid');
        $('#genotype_error').removeClass('d-none');
        isValid = false;
    }

    if (title.trim() === '') {
        $('#title').addClass('is-invalid');
        $('#title_error').removeClass('d-none');
        isValid = false;
    }

    if (fly_condition.trim() === '') {
        $('#fly_condition').addClass('is-invalid');
        $('#fly_condition_error').removeClass('d-none');
        isValid = false;
    }

     if (requested_fly_status.trim() === '') {
        $('#requested_fly_status').addClass('is-invalid');
        $('#requested_fly_status_error').removeClass('d-none');
        isValid = false;
    }

    if (generated_by.trim() === '') {
        $('#generated_by').addClass('is-invalid');
        $('#generated_by_error').removeClass('d-none');
        isValid = false;
    }

    if (gene_affected.trim() === '') {
        $('#gene_affected').addClass('is-invalid');
        $('#gene_affected_error').removeClass('d-none');
        isValid = false;
    }

    if (pi_email.trim() === '') {
        $('#pi_email').addClass('is-invalid');
        $('#pi_email_error').removeClass('d-none');
        isValid = false;
    }


    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) {
                $('#stock_save_error').addClass('d-none');
                $('#stock_save_success').removeClass('d-none');
                setTimeout(function(){     
                    window.location.reload();
                    $('#stock_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stock_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stock_save_error').removeClass('d-none');
        $('#stock_save_success').addClass('d-none');
    }
});


$('#assign-stock').on('click', function() {
    var checkedIds = $('.selected-stock-row:checked').map(function() {
        return this.id;
    }).get();
    var aid = $('#admin').val();
    if(checkedIds == ''){
        Swal.fire({
            icon: "warning",
            title: "Stock",
            text: "Choose stock!",
            confirmButtonClass: "btn btn-danger",
          });
    } else {
        var base_url = $('#base_url').val();
        Swal.fire({
            title: "Are you sure you want to assign these stock?",
            // text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, Assign it!",
            confirmButtonClass: "btn btn-success",
            cancelButtonClass: "btn btn-danger ml-1",
            buttonsStyling: false,
          }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: base_url+'stock/assign-stock-admin',
                    data: {'s_id' : checkedIds,'aid':aid },
                    success: function(data) {
                        Swal.fire({
                                    icon: "success",
                                    title: "Assigned!",
                                    text: "Stocks has been Assigned.",
                                    confirmButtonClass: "btn btn-success",
                                  });
                                $('#assign-admin-stock').modal('hide');
                                var table = $('.datastock').DataTable();
                                table.ajax.reload();               
                    },
                    error: function(xhr, status, error) {
                        alert('An error occurred: ' + error);
                    }
                });
            }
          });
    }
});

  