<?php

namespace App\Controllers;

use App\Models\EventNews_Model;
use App\Models\Security_Model;

class Website extends BaseController
{
    protected $eventnewsModel;
    protected $securityModel;

    public function __construct()
    {
        $this->eventnewsModel = new EventNews_Model();
        $this->securityModel = new Security_Model();
        $this->request = service('request');
    }

    public function event(): string
    {
		return view('event');
    }

    public function getAll()
    {
        $data = $this->eventnewsModel->findAll();
        return json_encode($data);
    }

    public function save()
    {
        $newsevent = $this->request->getPost();
        $this->securityModel->sanitize_form_array($newsevent);
        $file = $this->request->getFile('n_image');
        if($file != ''){
            $newsevent['n_image'] = $file->getClientName();
            if ($file->isValid() && !$file->hasMoved()) {
                $path = WRITEPATH . 'uploads/';
                $file->move($path);
            }
        }
        if($this->eventnewsModel->save($newsevent)){
            return true;
        } else {
            return false;
        }
    }

    public function getById($n_id)
    {
        $data = $this->eventnewsModel->where('n_id', $n_id)->first();
        return json_encode($data);
    }

    public function update()
    {
        $n_id = $this->request->getPost('n_id');
        $eventnews = array();
        $eventnews['n_title'] = $this->request->getPost('n_title');
        $eventnews['n_content'] = $this->request->getPost('n_content');
        $eventnews['e_title'] = $this->request->getPost('e_title');
        $eventnews['e_date'] = $this->request->getPost('e_date');
        $eventnews['e_description'] = $this->request->getPost('e_description');
        $this->securityModel->sanitize_form_array($eventnews);
        $file = $this->request->getFile('n_image');
        if($file != ''){
            $eventnews['n_image'] = $file->getClientName();
            if ($file->isValid() && !$file->hasMoved()) {
                $path = WRITEPATH . 'uploads/';
                $file->move($path);
            }
        }
        if($this->eventnewsModel->update($n_id,$eventnews)){
            return true;
        } else {
            return false;
        }
    }

    public function delete()
    {
        $n_id = $this->securityModel->sanitize_input($this->request->getPost('n_id'));
        if($this->eventnewsModel->delete($n_id)){
            return true;
        } else {
            return false;
        }  
    }
}
