$(document).ready(function(){
    getOrderStatusData();
});
function getOrderStatusData(){
    if($('.dataorderstatus').length > 0) {
    $('.dataorderstatus').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class="fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
      "ajax": {
      "url":  "get-order-status", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
        { "data": "os_id" },
        { "data": "status" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.os_id}' onclick='editOrderStatus(${row.os_id})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.os_id}' onclick='deleteOrderStatus(${row.os_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
    }
}
function editOrderStatus(os_id){   
    $.ajax({
            type: "GET",
            url: "edit-order-status/"+os_id,
            dataType: 'json',
            success: function(data) { 
                $('#os_id').val(data.os_id);
                $('#status').val(data.status);
                $('#edit-order-status').modal('show');
            },
            error: function(xhr, status, error) {
                $('#orderstatus_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$("#order_status_edit_form").submit(function(e) {
    e.preventDefault(); 

    var status = $('#status').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (status.trim() === '') {
        $('#status').addClass('is-invalid');
        $('#status_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#orderstatus_edit_error').addClass('d-none');
                $('#orderstatus_edit_success').removeClass('d-none');
                var table = $('.dataorderstatus').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#edit-order-status').modal('hide');
                    $('#orderstatus_edit_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#orderstatus_edit_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#orderstatus_save_error').removeClass('d-none');
        $('#orderstatus_save_success').addClass('d-none');
    }
});


$("#order_status_form").submit(function(e) {
    e.preventDefault(); 

    var os_name = $('#os_name').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (os_name.trim() === '') {
        $('#os_name').addClass('is-invalid');
        $('#os_name_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#orderstatus_save_error').addClass('d-none');
                $('#orderstatus_save_success').removeClass('d-none');
                $('#order_status_form')[0].reset();
                var table = $('.dataorderstatus').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#add-order-status').modal('hide');
                    $('#order_status_form')[0].reset();
                    $('#orderstatus_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#orderstatus_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#orderstatus_save_error').removeClass('d-none');
        $('#orderstatus_save_success').addClass('d-none');
    }
});

function deleteOrderStatus(os_id){
    var os_id = os_id;
    Swal.fire({
    title: "Are you sure you want to delete this Order Status?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
        $.ajax({
            type: "POST",
            url: "delete-order-status", 
            data: {os_id:os_id},
            success: function(data) {
                Swal.fire({
                            icon: "success",
                            title: "Deleted!",
                            text: "Order Status details has been deleted.",
                            confirmButtonClass: "btn btn-success",
                          });
                                var table = $('.dataorderstatus').DataTable();
                                table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}