$(document).ready(function(){
    getAvailabilityData();
});
function getAvailabilityData(){
    if($('.dataAvailability').length > 0) {
    $('.dataAvailability').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class="fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
      "ajax": {
      "url":  "availability/get-availability", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
        { "data": "av_id" },
        { "data": "av_name" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.av_id}' onclick='editAvailability(${row.av_id})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.av_id}' onclick='deleteAvailability(${row.av_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
    }
}
function editAvailability(av_id){   
    $.ajax({
            type: "GET",
            url: "availability/edit-availability/"+av_id,
            dataType: 'json',
            success: function(data) { 
                $('#av_id').val(data.av_id);
                $('#av_name1').val(data.av_name);
                $('#edit-availability').modal('show');
            },
            error: function(xhr, status, error) {
                $('#availability_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$("#availability_edit_form").submit(function(e) {
    e.preventDefault(); 

    var av_name = $('#av_name1').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (av_name.trim() === '') {
        $('#av_name1').addClass('is-invalid');
        $('#av_name1_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#availability_edit_error').addClass('d-none');
                $('#availability_edit_success').removeClass('d-none');
                var table = $('.dataAvailability').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#edit-availability').modal('hide');
                    $('#availability_edit_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#availability_edit_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#availability_save_error').removeClass('d-none');
        $('#availability_save_success').addClass('d-none');
    }
});


$("#availability_form").submit(function(e) {
    e.preventDefault(); 

    var av_name = $('#av_name').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (av_name.trim() === '') {
        $('#av_name').addClass('is-invalid');
        $('#av_name_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#availability_save_error').addClass('d-none');
                $('#availability_save_success').removeClass('d-none');
                $('#availability_form')[0].reset();
                var table = $('.dataAvailability').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#add-availability').modal('hide');
                    $('#availability_form')[0].reset();
                    $('#availability_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#availability_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#availability_save_error').removeClass('d-none');
        $('#availability_save_success').addClass('d-none');
    }
});

function deleteAvailability(av_id){
    var av_id = av_id;
    Swal.fire({
    title: "Are you sure you want to delete this Availability?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
        $.ajax({
            type: "POST",
            url: "availability/delete-availability", 
            data: {av_id:av_id},
            success: function(data) {
                Swal.fire({
                            icon: "success",
                            title: "Deleted!",
                            text: "Availability details has been deleted.",
                            confirmButtonClass: "btn btn-success",
                          });
                                var table = $('.dataAvailability').DataTable();
                                table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}