<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Stock transfer List</h4>
								<h6>Manage Your stocks transfer records</h6>
							</div>
						</div>
						<div class="page-btn">
							<a href="#" class="btn btn-added" data-bs-toggle="modal" data-bs-target="#add-stocktransfer"><i data-feather="plus-circle" class="me-2"></i>New Transfer</a>
						</div>
					</div>


					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<div class="search-path">
									<div class="d-flex align-items-center">
										<a class="btn btn-filter" id="filter_search">
											<i data-feather="filter" class="filter-icon"></i>
											<span><img src="<?= base_url('public/assets/img/icons/closes.svg');?>" alt="img"></span>
										</a>
									</div>
								</div>
								
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">										
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="zap" class="info-img"></i>
												<select class="select" id="stockId_filter" name="stockId_filter">
													<option>Choose Stock ID</option>
													<?php foreach ($stocks as $stock): ?>
													<option value="<?= $stock['s_id'] ?>"><?= $stock['s_id'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="zap" class="info-img"></i>
												<select class="select" id="handlerName_filter" name="handlerName_filter">
													<option>Choose Handler</option>
													<?php foreach ($users as $user): ?>
													<option value="<?= $user['uname'] ?>"><?= $user['uname'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<input type="date" class="form-control" id="transferdate_filter">
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="table-responsive">
								<table class="table dataStockTracknew">
									<thead>
										<tr>									
											<th>Stock ID</th>											
											<th>Current Handler name</th>								
											<th>Transfer Date</th>
											<th>Comments</th>	
											<th class="no-sort">Action</th>
										</tr>
									</thead>
									<tbody>
										
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		<!-- Add User -->
		<div class="modal fade" id="add-stocktransfer">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Transfer Fly Stocks Form</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form id="stock_transfer_form" action="<?=base_url('stock/saveStockTransfer');?>">
									<div class="row">	
										<div class="col-lg-12 d-none" id="stocktransfer_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="stocktransfer_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form submitted successfully!</center>
											</div>
											<br />
										</div> 		
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Stock ID</label>
												<select class="select" id="st_stock_id" name="st_stock_id">
													<option value="">Choose Stock ID</option>
													<?php foreach ($stocks as $stock): ?>
													<option value="<?= $stock['s_id'] ?>"><?= $stock['s_id'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="st_stock_id_error">Please provide a Stock ID</div>
											</div>
										</div>									
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Current Handler</label>
												<select class="select" id="st_current_handler" name="st_current_handler">
													<option value="">Choose Handler</option>
													<?php foreach ($users as $user): ?>
													<option value="<?= $user['uid'] ?>"><?= $user['uname'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="st_current_handler_error">Please choose Current Handler</div>
											</div>
										</div>										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>New Handler</label>
												<select class="select" id="st_new_handler" name="st_new_handler">
													<option value="">Choose Handler</option>
													<?php foreach ($users as $user): ?>
													<option value="<?= $user['uid'] ?>"><?= $user['uname'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="st_new_handler_error">Please choose New Handler</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Transfer date</label>
												<input type="date" class="form-control" id="st_transfer_date" name="st_transfer_date">
												<div class="invalid-feedback d-none" id="st_transfer_date_error">Please choose Transfer Date</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Comments</label>
												<textarea class="form-control" id="st_comments" name="st_comments"></textarea>
											</div>
										</div>
																			
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Save</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Add User -->
		<!-- View Stock Transfer Records -->
		<div class="modal fade" id="view-stocktransfer">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>View transfer details</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="users.php">
									<div class="row">	
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Stock ID</label>
												<select class="select" id="st_stock_id1" name="st_stock_id1" disabled>
													<option>Choose Stock ID</option>
													<?php foreach ($stocks as $stock): ?>
													<option value="<?= $stock['s_id'] ?>"><?= $stock['s_id'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>									
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Current Handler</label>
												<select class="select" id="st_current_handler1" name="st_current_handler1" disabled>
													<option>Choose Handler</option>
													<?php foreach ($users as $user): ?>
													<option value="<?= $user['uid'] ?>"><?= $user['uname'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>New Handler</label>
												<select class="select" id="st_new_handler1" name="st_new_handler" disabled>
													<option>Choose Handler</option>
													<?php foreach ($users as $user): ?>
													<option value="<?= $user['uid'] ?>"><?= $user['uname'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Transfer date</label>
												<input type="date" class="form-control" id="st_transfer_date1" name="st_transfer_date" readonly>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Comments</label>
												<textarea class="form-control" id="st_comments1" name="st_comments" readonly></textarea>
											</div>
										</div>
																			
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Edit User -->

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>