<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
     <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>  
<style>
.chart-container {
  width: 700px;
}
</style>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Stocks Count</h4>
								<h6>Manage Your stocks</h6>
							</div>
						</div>
						<div class="page-btn">
							<a href="<?= base_url('stock/move-stock'); ?>" class="btn btn-secondary rounded-pill">Move Stock <i data-feather="arrow-right" class="me-2"></i></a>
						</div>
						<!-- <div class="page-btn">
							<a href="<?= base_url('stock/assign'); ?>" class="btn btn-warning rounded-pill">Assign Stock <i data-feather="user" class="me-2"></i></a>
						</div> -->
					</div>
					<div class="row">
						<div class="col-xl-6 col-sm-12 col-6 d-flex">
							<div class="card flex-fill default-cover mb-4">
								<div class="card-body">
									<div class="dash-count das3">
										<div class="dash-counts">
											<h4 id="tcount">0</h4>
											<h5>Total Stock</h5>
										</div>
										<div class="dash-imgs">
											<i data-feather="file"></i>
										</div>
									</div>
								</div>
							</div>
						</div>
					
					</div>
                    <div class="row">

                    <div class="col-xl-6 col-sm-12 col-12 d-flex">
                        <div class="card flex-fill default-cover mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title">Common Collection Category Wise Count</h4>
                               
                            </div>
                            <div class="card-body">
                                <div class="table-responsive dataview">
                                    <table class="table dashboard-expired-products">
                                        <thead>
                                            <tr>
                                                <th class="no-sort">
                                                    Category Id
                                                </th>
                                                <th>Category Name</th>
                                                <th>Total Stock</th>
                                                                                              
                                            </tr>
                                        </thead>
                                        <tbody id="commonCategory">
                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                     <div class="col-xl-6 col-sm-12 col-12 d-flex">
                        <div class="card flex-fill default-cover mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title">Common Collection Fly Wise Count</h4>
                               
                            </div>
                            <div class="card-body">
                                <div class="table-responsive dataview">
                                    <table class="table dashboard-expired-products">
                                        <thead>
                                            <tr>
                                                <th class="no-sort">
                                                    Fly Status Id
                                                </th>
                                                <th>Fly Status Name</th>
                                                <th>Total Stock</th>
                                                                                              
                                            </tr>
                                        </thead>
                                        <tbody id="commonFly">
                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                        
                    </div>

                       <div class="row">

                    <div class="col-xl-6 col-sm-12 col-12 d-flex">
                        <div class="card flex-fill default-cover mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title">PI Collection PI Wise Count</h4>
                               
                            </div>
                            <div class="card-body">
                                <div class="table-responsive dataview">
                                    <table class="table dashboard-expired-products">
                                        <thead>
                                            <tr>
                                                <th class="no-sort">
                                                    PI Id
                                                </th>
                                                <th>PI Name</th>
                                                <th>Total Stock</th>
                                                                                              
                                            </tr>
                                        </thead>
                                        <tbody id="picollectionPi">
                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                     <div class="col-xl-6 col-sm-12 col-12 d-flex">
                        <div class="card flex-fill default-cover mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title">PI Collection Fly Wise Count</h4>
                               
                            </div>
                            <div class="card-body">
                                <div class="table-responsive dataview">
                                    <table class="table dashboard-expired-products">
                                        <thead>
                                            <tr>
                                                <th class="no-sort">
                                                    FLy Status Id
                                                </th>
                                                <th>Fly Status Name</th>
                                                <th>Total Stock</th>
                                                                                              
                                            </tr>
                                        </thead>
                                        <tbody id="piFly">
                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                        
                    </div>
		

				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>
<script>
var base_url = $('#base_url').val();


$(document).ready(function(){
    getDashboardData();
});
function getDashboardData(){
    $.ajax({
        type: "GET",
        url: base_url + 'count-chart',
        dataType: 'json',
        success: function(data) { 
            // $('#uCount').html(data.total['uCount']);
            // $('#gCount').html(data.total['gCount']);
            // $('#oCount').html(data.total['oCount']);
            // $('#sCount').html(data.total['sCount']);
                // var result = JSON.parse(data);
                // var tcount = result.tcount;
                $('#tcount').html(data.tcount);
            var catdata = data.commonCatwise;
            for(var i = 0; i < catdata.length; i++){
                $('#commonCategory').append('<tr>'+
                                                    '<td>'+
                                                        '<label class="checkboxs">'+catdata[i].id+'</label>'+    
                                                    '</td>'+
                                                    '<td>'+
                                                        '<div class="productimgname">'+catdata[i].category+'</div>'+ 
                                                    '</td>'+
                                                    '<td><a href="javascript:void(0);">'+catdata[i].count+'</a></td>'+
                                                    // '<td>'+catdata[i].role+'</td>'+
                                                    // '<td>'+catdata[i].date+'</td>'+
                                                '</tr>');
            }
            var catflydata = data.commonFlyWise;
            for(var i = 0; i < catflydata.length; i++){
                $('#commonFly').append('<tr>'+
                                                    '<td>'+
                                                        '<label class="checkboxs">'+catflydata[i].id+'</label>'+    
                                                    '</td>'+
                                                    '<td>'+
                                                        '<div class="productimgname">'+catflydata[i].flycondition+'</div>'+ 
                                                    '</td>'+
                                                    '<td><a href="javascript:void(0);">'+catflydata[i].count+'</a></td>'+
                                                    // '<td>'+catflydata[i].role+'</td>'+
                                                    // '<td>'+catflydata[i].date+'</td>'+
                                                '</tr>');
            }
             var collectPiWise = data.piCollectionPiWise;
            for(var i = 0; i < collectPiWise.length; i++){
                $('#picollectionPi').append('<tr>'+
                                                    '<td>'+
                                                        '<label class="checkboxs">'+collectPiWise[i].id+'</label>'+    
                                                    '</td>'+
                                                    '<td>'+
                                                        '<div class="productimgname">'+collectPiWise[i].uname+'</div>'+ 
                                                    '</td>'+
                                                    '<td><a href="javascript:void(0);">'+collectPiWise[i].count+'</a></td>'+
                                                    // '<td>'+catdata[i].role+'</td>'+
                                                    // '<td>'+catdata[i].date+'</td>'+
                                                '</tr>');
            }
            var piflydata = data.piCollectionFlyWise;
            for(var i = 0; i < piflydata.length; i++){
                $('#piFly').append('<tr>'+
                                                    '<td>'+
                                                        '<label class="checkboxs">'+piflydata[i].id+'</label>'+    
                                                    '</td>'+
                                                    '<td>'+
                                                        '<div class="productimgname">'+piflydata[i].flycondition+'</div>'+ 
                                                    '</td>'+
                                                    '<td><a href="javascript:void(0);">'+piflydata[i].count+'</a></td>'+
                                                    // '<td>'+piflydata[i].role+'</td>'+
                                                    // '<td>'+piflydata[i].date+'</td>'+
                                                '</tr>');
            }

        },
        error: function(xhr, status, error) {
            $('#group1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
        }
    });
}


</script>