<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
</head>
<style>
.barcode-grid {
    display: flex;
    flex-direction: column; /* Stack items vertically */
    align-items: center;    /* Center each barcode horizontally */
    gap: 20px;              /* Space between barcodes */
    margin-top: 20px;
}

.barcode-item {
    width: 300px;           /* Adjust width for your barcode */
    text-align: center;     /* Center text inside the item */
    padding: 10px;
    border: 1px solid #ccc;
    box-sizing: border-box;
    page-break-inside: avoid; /* Prevent splitting when printing */
}

.barcode-item img {
    width: 250px;           /* Adjust size for printing */
    height: 60px;
    display: block;
    margin: 0 auto 5px;
}

/* Print Button */
.print-btn {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    font-size: 16px;
    cursor: pointer;
    border-radius: 5px;
    margin-bottom: 20px;
    transition: background-color 0.3s;
}

.print-btn:hover {
    background-color: #0056b3;
}

@media print {
    .print-btn {
        display: none; /* Hide button in print */
    }
}
</style>

<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Barcode List</h4>
								<h6>Manage Your Barcodes</h6>
							</div>
						</div>
						<!-- <div class="page-btn">
							<a href="<?= base_url('stock/barcode-generation'); ?>" class="btn btn-added"><i data-feather="plus-circle" class="me-2"></i>Generate New Barcode</a>
						</div> -->
					</div>


					<!-- /product list -->
					<button class="print-btn" onclick="printBarcodes()"> Print Barcodes</button>

   <div class="barcode-grid">
    <?php foreach($stocks as $st): ?>
        <div class="barcode-item">
            <img src="<?= base_url('code128/'.$st->ncbs_id) ?>" alt="barcode">
            <div><b><?= $st->ncbs_id ?></b></div>
            <small><?= $st->old_ncbs_id ?></small>
                        <small><?= $st->title ?></small>
        </div>
    <?php endforeach; ?>
</div>

					<!-- /product list -->
				</div>
			</div>
			<script>
        function printBarcodes() {
            const images = document.querySelectorAll('.barcode-item img');
            let loadedCount = 0;

            images.forEach(img => {
                if (img.complete) {
                    loadedCount++;
                } else {
                    img.onload = () => {
                        loadedCount++;
                        if (loadedCount === images.length) {
                            window.print();
                        }
                    };
                }
            });

            if (loadedCount === images.length) {
                window.print();
            }
        }
    </script>

        </div>
		<!-- /Main Wrapper -->
    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>
<script src="https://cdn.rawgit.com/lindell/JsBarcode/master/dist/JsBarcode.all.min.js"></script>
<?php echo view('layouts/footer.php'); ?>



<script>
function printBarcodes() {
    const images = document.querySelectorAll('.barcode-item img');
    let loadedCount = 0;

    images.forEach(img => {
        if (img.complete) {
            loadedCount++;
        } else {
            img.onload = () => {
                loadedCount++;
                if (loadedCount === images.length) {
                    window.print();
                }
            };
        }
    });

    if (loadedCount === images.length) {
        window.print();
    }
}
</script>







