<?php

namespace App\Controllers;

use App\Models\Availability_Model;

class Availability extends BaseController
{
    protected $availabilityModel;
    protected $request;

    public function __construct()
    {
        $this->availabilityModel = new Availability_Model();
        $this->request = service('request');
    }
  
    public function index()
    { 
        return view('availability');
    }

    public function get()
    {
        $data = $this->availabilityModel->findAll();
        echo json_encode($data);
    }

    public function edit($av_id)
    {
        $data = $this->availabilityModel->where('av_id',$av_id)->first();
        echo json_encode($data);
    }

     public function save()
    {
        $name = $this->request->getPost();
        if($this->availabilityModel->save($name)){
            return true;
        } else {
            return false;
        }
    }

    public function update()
    {
        $av_id = $this->request->getPost('av_id');
        $name = array();
        $name['av_name'] = $this->request->getPost('av_name');
        if($this->availabilityModel->update($av_id,$name)){
            return true;
        } else {
            return false;
        }
    }

    public function delete()
    {
        $av_id = $this->request->getPost('av_id');
        if($this->availabilityModel->delete($av_id)){
            return true;
        } else {
            return false;
        }  
    }
   
}
