<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

$routes->get('/send-email', 'MailController::send');

$routes->post('/login', 'Home::login');

$routes->get('/logout', 'Home::logout');

$routes->get('/register', 'Home::register');

$routes->get('/dashboard', 'Dashboard::index');

$routes->get('/flychart', 'Dashboard::getFlyCondition');

$routes->get('/pi-flychart', 'Dashboard::getFlyConditionPi');

$routes->get('/my-flychart', 'Dashboard::getFlyConditionMy');

$routes->get('/pi-dashboard', 'Dashboard::piindex');

$routes->get('/pi-dashboard/get/(:num)', 'Dashboard::getPiAll/$1');

$routes->get('/dashboard/get', 'Dashboard::getAll');

$routes->get('/my-dashboard', 'Dashboard::myIndex');

$routes->get('/profile', 'Home::getProfile');

$routes->post('/profile-update', 'Home::profileUpdate');

$routes->get('/user', 'User::index');

$routes->get('/user-activities', 'User::activities');

$routes->get('/user/get-activities', 'User::getActivities');

$routes->get('/user/approve', 'User::approveUser');

$routes->get('/user/get', 'User::getAll');

$routes->get('/user/get-new', 'User::getNotApprovedUser');

$routes->get('/user/getById/(:num)', 'User::getById/$1');

$routes->post('/user/save', 'User::save');

$routes->post('/user/update', 'User::update');

$routes->post('/user/update-role', 'User::assignRole');

$routes->post('/user/update-group', 'User::assignGroup');

$routes->post('/user/delete', 'User::delete');

$routes->post('/user/change-status', 'User::changeStatus');

$routes->post('/user/change-approve', 'User::approveUserStatus');

$routes->get('/group', 'Group::index');

$routes->get('/pi-group', 'Group::pigroup');

$routes->get('/pi-group/get/(:num)', 'Group::piGroupData/$1');

$routes->get('/pi-group-details/(:num)', 'Group::piGroupDetails/$1');

$routes->get('/pi-order', 'Order::piOrder');

$routes->get('/pi-order/get', 'Order::getPiOrder');

$routes->post('/group/save', 'Group::save');

$routes->get('/group/get', 'Group::getAll');

$routes->get('/group/getUserList', 'Group::getUserList');

$routes->get('/group/getById/(:num)', 'Group::getById/$1');

$routes->post('/group/update', 'Group::update');

$routes->post('/group/save-member', 'Group::saveUserGroup');

$routes->post('/group/pi-group-user-delete', 'Group::deleteGroupUser');

$routes->post('/group/delete', 'Group::delete');

$routes->get('/communication', 'Communication::index');

$routes->get('/communication/get', 'Communication::getAll');

$routes->post('/communication/save', 'Communication::save');

$routes->get('/my-notification', 'Notification::index');

$routes->get('/my-notification-list', 'Dashboard::getNotification');

$routes->get('/my-notification/get', 'Notification::getAll');

$routes->get('/my-order', 'Order::myOrder');

$routes->get('/stock/(:num)', 'Stock::index/$1');


$routes->get('/code128/(:segment)', 'Stock::code128/$1');

$routes->post('/stock/barcodeRange', 'Stock::barcodeRange');



$routes->get('/fly-centers', 'FlyCenter::index');

$routes->get('/fly-centers/get', 'FlyCenter::get');

$routes->post('/fly-centers/save', 'FlyCenter::save');

$routes->post('/fly-centers/update', 'FlyCenter::update');

$routes->post('/fly-centers/delete', 'FlyCenter::delete');

$routes->get('/fly-centers/edit/(:num)', 'FlyCenter::edit/$1');

$routes->get('/fly-condition', 'FlyCondition::index');

$routes->get('/fly-condition/get', 'FlyCondition::get');

$routes->post('/fly-condition/save', 'FlyCondition::save');

$routes->post('/fly-condition/update', 'FlyCondition::update');

$routes->post('/fly-condition/delete', 'FlyCondition::delete');

$routes->get('/fly-condition/edit/(:num)', 'FlyCondition::edit/$1');

$routes->get('/fly-request', 'FlyRequest::index');

$routes->get('/fly-request/get', 'FlyRequest::getAllFlyRequest');

$routes->get('/fly-request/add', 'FlyRequest::addFlyRequest');

$routes->post('/fly-request/save', 'FlyRequest::saveFlyRequest');

$routes->get('/fly-request/edit/(:num)', 'FlyRequest::editFlyRequest/$1');

$routes->post('/fly-request/update', 'FlyRequest::updateFlyRequest');

$routes->get('/fly-request/view/(:num)', 'FlyRequest::viewFlyRequest/$1');

$routes->post('/fly-request/delete', 'FlyRequest::deleteFlyRequest');

$routes->get('/fly-request/bulk-upload', 'FlyRequest::flyRequestBulkUpload');

$routes->post('/fly-request/bulk-upload-save', 'FlyRequest::flyRequestBulkUploadSave');

$routes->get('/availability', 'Availability::index');

$routes->get('/availability/get-availability', 'Availability::get');

$routes->post('/availability/save', 'Availability::save');

$routes->post('/availability/update', 'Availability::update');

$routes->post('/availability/delete-availability', 'Availability::delete');

$routes->get('/availability/edit-availability/(:num)', 'Availability::edit/$1');

$routes->get('/requested-fly-status', 'RequestedFlyStatus::index');

$routes->get('/requested-fly-status/get', 'RequestedFlyStatus::get');

$routes->post('/requested-fly-status/save', 'RequestedFlyStatus::save');

$routes->post('/requested-fly-status/update', 'RequestedFlyStatus::update');

$routes->post('/requested-fly-status/delete', 'RequestedFlyStatus::delete');

$routes->get('/requested-fly-status/edit/(:num)', 'RequestedFlyStatus::edit/$1');

$routes->get('/pi-stock/(:num)', 'Stock::pistock/$1');

$routes->get('/pi-stock-request', 'Stock::piStockRequest');

$routes->get('/pi-stock/getPiStockRequest', 'Stock::getPiStockRequest');

$routes->get('/my-stock', 'Stock::myStock');

$routes->get('/pi-stock/getPiStock/(:num)', 'Stock::getPiStock/$1');

$routes->get('/pi-stock/getStockDetails/(:num)', 'Stock::getStockDetails/$1');

$routes->get('/pi-cart', 'Stock::picart');

$routes->get('/my-cart', 'Stock::myCart');

$routes->post('/pi-save-cart', 'Stock::piSaveCart');

$routes->get('/pi-cart/getPiCart/(:num)', 'Stock::getPiCart/$1');

$routes->post('/pi-save-order', 'Stock::piPlaceOrder');

$routes->get('/stock/get/(:num)', 'Stock::getAll/$1');

$routes->post('/stock/delete', 'Stock::delete');

$routes->get('/stock/add-stock/(:num)', 'Stock::addStock/$1');

$routes->get('/stock/add-stock-request', 'Stock::addStockRequestPage');

$routes->post('/stock/save', 'Stock::save');

$routes->get('/stock/edit-stock/(:num)', 'Stock::editStock/$1');

$routes->get('/stock/edit-stock-request/(:num)', 'Stock::editStockRequest/$1');

$routes->get('/stock/view-stock/(:num)', 'Stock::viewStock/$1');

$routes->get('/stock/view-stock-request/(:num)', 'Stock::viewStockRequest/$1');

$routes->post('/stock/update', 'Stock::update');

$routes->get('/stock/bulk-upload', 'Stock::bulkUpload');

$routes->post('/stock/bulk-upload-save', 'Stock::bulkUploadSave');

$routes->get('/stock/stock-bulk-upload', 'Stock::stockBulkUpload');

$routes->post('/stock/stock-bulk-upload-save', 'Stock::stockBulkUploadSave');

$routes->get('/stock/barcode-generation', 'Stock::barcodeGeneration');

$routes->get('/stock/barcode-list', 'Stock::barcodeList');

$routes->get('/stock/barcode/get', 'Stock::getBarcodeList');

$routes->post('/stock/barcode/delete', 'Stock::deleteBarcode');

$routes->get('/stock/handling-records', 'Stock::handlingRecords');

$routes->get('/stock/tracking-records', 'Stock::trackingRecords');

$routes->get('/stock/tracking-records/get', 'Stock::getTrackingRecords');

$routes->post('/stock/tracking-records/orderDate', 'Stock::transferDate');

$routes->post('/stock/saveStockTransfer', 'Stock::saveTrackingRecords');

$routes->get('/stock/getStockTransferId/(:num)', 'Stock::getStockTransferId/$1');

$routes->post('/stock/searchStock', 'Stock::searchStock');

$routes->post('/stock/saveBarcode', 'Stock::saveBarcode');

$routes->get('/website/event', 'Website::event');

$routes->get('/website/event/get', 'Website::getAll');

$routes->post('/website/event/save', 'Website::save');

$routes->get('/website/event/getById/(:num)', 'Website::getById/$1');

$routes->post('/website/event/update', 'Website::update');

$routes->post('/website/event/delete', 'Website::delete');

$routes->get('/order', 'Order::index');

$routes->get('/order/get', 'Order::getAll');

$routes->get('/order/getById/(:num)', 'Order::getById/$1');

$routes->post('/order/update', 'Order::update');

$routes->post('/order/orderStatus', 'Order::orderStatus');

$routes->post('/order/orderDate', 'Order::orderDate');

$routes->post('/order/add-courier', 'Order::addCourier');

$routes->get('/order/getCourierDetails/(:num)', 'Order::getCourierDetails/$1');

$routes->get('/order/order-status-page', 'Order::orderStatusPage');

$routes->get('/order/get-order-status', 'Order::getorderStatus');

$routes->post('/order/save-order-status', 'Order::saveOrderStatus');

$routes->post('/order/update-order-status', 'Order::updateOrderStatus');

$routes->post('/order/delete-order-status', 'Order::deleteOrderStatus');

$routes->get('/order/edit-order-status/(:num)', 'Order::editOrderStatu/$1');


$routes->get('/permission', 'Permission::index');

$routes->get('/permission/get/(:num)', 'Permission::getAll/$1');

$routes->post('/permission/save', 'Permission::save');

$routes->get('/stock-category', 'StockCategory::index');

$routes->get('/stock-category/get', 'StockCategory::getAll');

$routes->post('/stock-category/save', 'StockCategory::save');

$routes->get('/stock-category/getById/(:num)', 'StockCategory::getById/$1');

$routes->post('/stock-category/update', 'StockCategory::update');

$routes->post('/stock-category/delete', 'StockCategory::delete');

$routes->post('/stock/bulk-view', 'Stock::bulkView');

$routes->post('/stock/bulk-delete', 'Stock::bulkDelete');

$routes->post('/stock/bulk-download', 'Stock::bulkDownload');

$routes->get('/stock/bulk-edit', 'Stock::bulkEdit');

$routes->post('/stock/bulk-edit-submit', 'Stock::bulkEditSubmit');

$routes->get('/stock/move-stock', 'Stock::moveStock');

$routes->post('/stock/getStockByCategory', 'Stock::getStockByCategory');

$routes->post('/stock/assign-stock', 'Stock::assignStock');

$routes->get('/stock/assign', 'Stock::assignTo');

$routes->post('/stock/assign-stock-la', 'Stock::assignToLA');

$routes->post('/stock/assign-stock-admin', 'Stock::assignStockAdmin');

$routes->get('/stock/count', 'Stock::stockCount');

$routes->get('/count-chart', 'Stock::countChart');

$routes->post('/stock/acceptStock', 'Stock::acceptStock');