$(document).ready(function(){
	getUserData();
    getNotApprovedUser();
    getUserActivities();
});

function getUserActivities(){
    if($('.userHistory').length > 0) {
    var table = $('.userHistory').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": "user/get-activities", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
            { "data" : "aid"},
            {
              "data": null, 
              "render": function (data, type, row) {
                 return `${row.a_data} by ${row.uname}`;
              }
            },
        ],
           
        });
        
    }
}

function getUserData(){
	if($('.datanew').length > 0) {
	var table = $('.datanew').DataTable({
			"bFilter": true,
			"sDom": 'fBtlpi',
      "paging": true,
      "pageLength": 100,   
			"ordering": false,
			"language": {
				search: ' ',
				sLengthMenu: '_MENU_',
				searchPlaceholder: "Search",
				info: "_START_ - _END_ of _TOTAL_ items",
				paginate: {
					next: ' <i class=" fa fa-angle-right"></i>',
					previous: '<i class="fa fa-angle-left"></i> '
				},
			 },
		 "ajax": {
      "url": "user/get", 
      "type": "GET", 
      "dataSrc": "" 
  		},
    	"columns": [
        {
          "data": null, 
          "render": function (data, type, row) {
             if(row.is_active == 1){
                return `<a onclick='viewUser(${row.uid})'><u>${row.uname}</u></a>`;
             } else {
                return `<a onclick='viewUser(${row.uid})'><u><span class="text-danger">${row.uname}</span></u></a>`;
             }
          }
        },
        {
          "data": null, 
          "render": function (data, type, row) {
             if(row.is_active == 1){
                return `${row.uemail}`;
             } else {
                return `<span class="text-danger">${row.uemail}</span>`;
             }
          }
        },
        {
          "data": null, 
          "render": function (data, type, row) {
             if(row.is_active == 1){
                return `${row.role}`;
             } else {
                return `<span class="text-danger">${row.role}</span>`;
             }
          }
        },
        {
          "data": null, 
          "render": function (data, type, row) {
             if(row.is_active == 1){
                return `${row.gname}`;
             } else {
                return `<span class="text-danger">${row.gname}</span>`;
             }
          }
        },
        {
          "data": null, 
          "render": function (data, type, row) {
              if(row.is_active == 1){
                return `<a class="btn btn-success">Active</a>`;
              } else {
                return `<a class="btn btn-danger">De-active</a>`;
              }
          }
        },
        {
          "data": null, 
          "render": function (data, type, row) {
              if(row.is_active == 1){
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.uid}' onclick='editUser(${row.uid})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.uid}' onclick='deleteUser(${row.uid})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                          <a class="btn btn-outline-danger" onclick="changeStatus(${row.uid},${row.is_active})">De-activate</a>
                      </div>`;
              } else {
                return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.uid}' onclick='editUser(${row.uid})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.uid}' onclick='deleteUser(${row.uid})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                          <a class="btn btn-outline-success" onclick="changeStatus(${row.uid},${row.is_active})">Activate</a>
                      </div>`;
              }
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
			initComplete: (settings, json)=>{
				$('.dataTables_filter').appendTo('#tableSearch');
				$('.dataTables_filter').appendTo('.search-input');

			},	
		});
		$('#role_filter').on('change', function() {
            
            if($(this).val() == '' && $('#group_filter').val() == '' ){
              
               table.search('').draw();

            }else if ($(this).val() == '' && $('#group_filter').val() != '' ){

                table.search($('#group_filter').val()).draw();

            }else{
              
                table.search($(this).val()).draw();
            }
            
    });
        $('#group_filter').on('change', function() {
          
             if($(this).val() == '' && $('#role_filter').val() == '' ){
              
               table.search('').draw();

            }else if ($(this).val() == '' && $('#role_filter').val() != '' ){

                table.search($('#role_filter').val()).draw();

            }else{
              
                table.search($(this).val()).draw();
            }
        });
	}
}


function getNotApprovedUser(){
    var base_url = $('#base_url').val();
    // Fetch users and roles
    $.ajax({
        url: base_url + "user/get-new",
        type: "GET",
        success: function(data) {
            // Assuming the API returns an object with user and role arrays
            var data = JSON.parse(data);
            const users = data.user; // User data
            const roles = data.role; // Role data
            const groups = data.group; // Role data
            // Initialize the DataTable after both sets of data are available
            var table = $('.datanewuser').DataTable({
                "bFilter": true,
                "sDom": 'fBtlpi',
                "ordering": true,
                "language": {
                    search: ' ',
                    sLengthMenu: '_MENU_',
                    searchPlaceholder: "Search",
                    info: "_START_ - _END_ of _TOTAL_ items",
                    paginate: {
                        next: ' <i class="fa fa-angle-right"></i>',
                        previous: '<i class="fa fa-angle-left"></i>'
                    },
                },
                "data": users, // Use the fetched user data directly
                "columns": [
                    { "data": "uname" },
                    { "data": "uemail" },
                    {
                        "data": null,
                        "render": function(data, type, row) {
                            if(row.role != null){
                                return row.role;
                            } else {
                                let select = '<select class="form-control role-select" onchange="assignRole(' + row.uid + ', this.value)">';
                                select += '<option>Assign Role</option>';
                                roles.forEach(function(role) {
                                    
                                                        if(role.r_id != 6){

                           
                                    select += `<option value="${role.r_id}" ${row.role_id === role.r_id ? 'selected' : ''}>${role.role}</option>`;
                                  }
                                });
                                select += '</select>';
                                return select;
                            }
                        }
                    },
                    {
                        "data": null,
                        "render": function(data, type, row) {
                            if(row.gname != null){
                                return row.gname;
                            } else {
                                let select = '<select class="form-control role-select" onchange="assignGroup(' + row.uid + ', this.value)">';
                                select += '<option>Assign Group</option>';
                                groups.forEach(function(group) {
                                    select += `<option value="${group.g_id}" ${row.g_id === group.g_id ? 'selected' : ''}>${group.gname}</option>`;
                                });
                                select += '</select>';
                                return select;
                            }
                        }
                    },
                    {
                        "data": null,
                        "render": function(data, type, row) {
                            return `<div class='edit-delete-action'>
                                        <a class="btn btn-outline-success" onclick="approveUser(${row.uid}, 1)">Approve</a>
                                        &nbsp;
                                        <a class="btn btn-outline-danger" onclick="approveUser(${row.uid}, 2)">Reject</a>
                                    </div>`;
                        },
                        "createdCell": function(td, cellData, rowData, row, col) {
                            $(td).addClass('action-table-data');
                        }
                    }
                ],
                initComplete: function(settings, json) {
                    $('.dataTables_filter').appendTo('#tableSearch');
                    $('.dataTables_filter').appendTo('.search-input');
                }
            });
        },
        error: function(xhr, status, error) {
            console.error('Error fetching data:', error);
        }
    });
}

// Function to handle role change
function assignRole(uid, roleId) {
    var base_url = $('#base_url').val();
    $.ajax({
        url: base_url + 'user/update-role',
        type: 'POST',
        data: {
            uid: uid,
            u_roll_id: roleId
        },
        success: function(response) {
            $('#user_role_success').removeClass('d-none');
            setTimeout(function(){
                $('#user_role_success').addClass('d-none');
                location.reload();
            }, 2000); 
        },
        error: function(xhr, status, error) {
            $('#user_role_error').removeClass('d-none');
        }
    });
}

// Function to handle role change
function assignGroup(uid, groupId) {
    var base_url = $('#base_url').val();
    $.ajax({
        url: base_url + 'user/update-group',
        type: 'POST',
        data: {
            uid: uid,
            g_id: groupId
        },
        success: function(response) {
            $('#user_group_success').removeClass('d-none');
            setTimeout(function(){
                $('#user_group_success').addClass('d-none');
                location.reload();
            }, 2000); 
        },
        error: function(xhr, status, error) {
            $('#user_group_error').removeClass('d-none');
        }
    });
}

function approveUser(uid,is_approve){

    var base_url = $('#base_url').val();
    var uid = uid;
    var is_approve = is_approve;
    if(is_approve == 1){
        Swal.fire({
            title: "Are you sure you want to APPROVE this user?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, APPROVE it!",
            confirmButtonClass: "btn btn-success",
            cancelButtonClass: "btn btn-danger ml-1",
            buttonsStyling: false,
          }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: base_url+"user/change-approve",
                    data: {uid:uid,is_approve:is_approve},
                    success: function(data) { 
                        Swal.fire({
                                    icon: "success",
                                    title: "Approved!",
                                    text: "User details has been approved.",
                                    confirmButtonClass: "btn btn-success",
                                  });
                        $('#user_approve_success').removeClass('d-none');
                        setTimeout(function(){
                            $('#user_approve_success').addClass('d-none');
                            window.location.reload();
                        }, 2000);              
                    },
                    error: function(xhr, status, error) {
                        $('#user_approve_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
                    }
                });
            }
          });

      } else {

        Swal.fire({
            title: "Are you sure you want to REJECT this user?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, REJECT it!",
            confirmButtonClass: "btn btn-success",
            cancelButtonClass: "btn btn-danger ml-1",
            buttonsStyling: false,
          }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: base_url+"user/change-approve",
                    data: {uid:uid,is_approve:is_approve},
                    success: function(data) {
                        Swal.fire({
                                    icon: "warning",
                                    title: "Deleted!",
                                    text: "User details has been rejected.",
                                    confirmButtonClass: "btn btn-warning",
                                  });
                        $('#user_approve_success').removeClass('d-none');
                        setTimeout(function(){
                            $('#user_approve_success').addClass('d-none');
                            var table = $('.datanew').DataTable();
                            table.ajax.reload();
                        }, 2000);            
                    },
                    error: function(xhr, status, error) {
                        $('#user_approve_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
                    }
                });
            }
          });

      }
}

function changeStatus(uid,is_active){
    var uid = uid;
    var is_active = is_active;
    if(is_active == 1){
        is_active = 0;
    } else {
        is_active = 1;
    }
    $.ajax({
            type: "POST",
            url: "user/change-status",
            data: {uid:uid, is_active:is_active},
            success: function(data) {
                if(is_active == 1){
                    $('#user_status_success').removeClass('d-none');
                    setTimeout(function(){
                        $('#user_status_success').addClass('d-none');
                        var table = $('.datanew').DataTable();
                        table.ajax.reload();
                    }, 2000);
                } else {
                    $('#user_status_success_1').removeClass('d-none');
                    setTimeout(function(){
                        $('#user_status_success_1').addClass('d-none');
                        var table = $('.datanew').DataTable();
                        table.ajax.reload();
                    }, 2000);
                }     
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}
function editUser(uid){	
	$.ajax({
            type: "GET",
            url: "user/getById/"+uid,
            dataType: 'json',
            success: function(data) {
        		$('#edit_uid').val(data.uid);
        		$('#uname1').val(data.uname);
        		$('#uemail1').val(data.uemail);
			    $('#upassword1').val(data.upassword);
			    $('#u_roll_id1').val(data.u_roll_id).trigger('change');
                $('#edit-units').modal('show');
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}
function viewUser(uid){ 
    $.ajax({
            type: "GET",
            url: "user/getById/"+uid,
            dataType: 'json',
            success: function(data) {
                $('#uname2').val(data.uname);
                $('#uemail2').val(data.uemail);
                $('#u_roll_id2').val(data.u_roll_id).trigger('change');
                $('#view-units').modal('show');
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}
$(document).ready(function() {
    $("#user_edit_form").submit(function(e) {
        e.preventDefault(); // Prevent default form submission

        var uname = $('#uname1').val();
        var uemail = $('#uemail1').val();
        var upassword = $('#upassword1').val();
        var u_roll_id = $('#u_roll_id1').val();
        
        var isValid = true; 

        // Clear previous validation states
        $('.is-invalid').removeClass('is-invalid');
        $('.error').addClass('d-none');
        
        // Validation
        if (uname == '') {
            $('#uname1').addClass('is-invalid');
            $('#uname1_error').removeClass('d-none');
            isValid = false;
        }

        if (uemail == '') {
            $('#uemail1').addClass('is-invalid');
            $('#uemail1_error').removeClass('d-none');
            isValid = false;
        } else if (!validateEmail(uemail)) {
            $('#uemail1').addClass('is-invalid');
            $('#uemail1_error').text('Invalid email format').removeClass('d-none');
            isValid = false;
        }

        if (upassword == '') {
            $('#upassword1').addClass('is-invalid');
            $('#upassword1_error').removeClass('d-none');
            isValid = false;
        }

        if (u_roll_id == '') {
            $('#u_roll_id1').addClass('is-invalid');
            $('#u_roll_id1_error').removeClass('d-none');
            isValid = false;
        }

        if (isValid) {
            var form = $(this);
            var actionUrl = form.attr('action');    
            $.ajax({
                type: "POST",
                url: actionUrl,
                data: form.serialize(),
                success: function(data) {
                    $('#user1_save_error').addClass('d-none');
                    $('#user1_save_success').removeClass('d-none');
                    var table = $('.datanew').DataTable();
                    table.ajax.reload();
                    setTimeout(function(){
                        $('#edit-units').modal('hide');
                        $('#user_edit_form')[0].reset();
                        $('.is-invalid').removeClass('is-invalid');
                        $('.error').addClass('d-none');
                        $('#user1_save_success').addClass('d-none');
                    }, 2000);
                },
                error: function(xhr, status, error) {
                    $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
                }
            });
        } else {
            $('#user1_save_error').removeClass('d-none');
            $('#user1_save_success').addClass('d-none');
        }
    });

    // Validate Email Function
    function validateEmail(email) {
        var regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return regex.test(email);
    }
});


$("#user_form").submit(function(e) {
    e.preventDefault(); // Prevent default form submission

    var uname = $('#uname').val();
    var uemail = $('#uemail').val();
    var upassword = $('#upassword').val();
    var u_roll_id = $('#u_roll_id').val();
    
    var isValid = true; 

    // Clear previous validation states
    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (uname == '') {
        $('#uname').addClass('is-invalid');
        $('#uname_error').removeClass('d-none');
        isValid = false;
    }

    if (uemail == '') {
        $('#uemail').addClass('is-invalid');
        $('#uemail_error').removeClass('d-none');
        isValid = false;
    } else if (!validateEmail(uemail)) {
        $('#uemail').addClass('is-invalid');
        $('#uemail_error').text('Invalid email format').removeClass('d-none');
        isValid = false;
    }

    if (upassword == '') {
        $('#upassword').addClass('is-invalid');
        $('#upassword_error').removeClass('d-none');
        isValid = false;
    }

    if (u_roll_id == '') {
        $('#u_roll_id').addClass('is-invalid');
        $('#u_roll_id_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) {
                $('#user_save_error').addClass('d-none');
                $('#user_save_success').removeClass('d-none');
                var table = $('.datanew').DataTable();
                table.ajax.reload();
                setTimeout(function(){
                    $('#add-units').modal('hide');
                    $('#user_form')[0].reset();
                    $('#u_roll_id').val(0).trigger('change');
                    $('#user_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#user_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#user_save_error').removeClass('d-none');
        $('#user_save_success').addClass('d-none');
    }
});

// Email validation function
function validateEmail(email) {
    var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return re.test(email);
}


function deleteUser(uid){
	var uid = uid;
	Swal.fire({
    title: "Are you sure you want to delete this user?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
    	$.ajax({
            type: "POST",
            url: "user/delete", 
            data: {uid:uid},
            success: function(data) {
                Swal.fire({
					        icon: "success",
					        title: "Deleted!",
					        text: "User details has been deleted.",
					        confirmButtonClass: "btn btn-success",
					      });
								var table = $('.datanew').DataTable();
								table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}