$(document).ready(function(){
    geFlyconditionData();
});
function geFlyconditionData(){
    if($('.dataflyStatus').length > 0) {
    $('.dataflyStatus').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": "requested-fly-status/get", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
        { "data": "fs_id" },
        { "data": "fs_name" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.fs_id}' onclick='editflycondition(${row.fs_id})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.fs_id}' onclick='deleteflycondition(${row.fs_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
    }
}
function editflycondition(fs_id){   
    $.ajax({
            type: "GET",
            url: "requested-fly-status/edit/"+fs_id,
            dataType: 'json',
            success: function(data) { 
                $('#fs_id').val(data.fs_id);
                $('#fs_name1').val(data.fs_name);
                $('#edit-fly-status').modal('show');
            },
            error: function(xhr, status, error) {
                $('#flycondition_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$("#fly_status_edit_form").submit(function(e) {
    e.preventDefault(); 

    var fs_name = $('#fs_name1').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (fs_name.trim() === '') {
        $('#fs_name1').addClass('is-invalid');
        $('#fs_name1_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#flystatus_edit_error').addClass('d-none');
                $('#flystatus_edit_success').removeClass('d-none');
                var table = $('.dataflyStatus').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#edit-fly-status').modal('hide');
                    $('#flystatus_edit_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#flystatus_edit_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#flystatus_save_error').removeClass('d-none');
        $('#flystatus_save_success').addClass('d-none');
    }
});


$("#fly_status_form").submit(function(e) {
    e.preventDefault(); 

    var fs_name = $('#fs_name').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (fs_name.trim() === '') {
        $('#fs_name').addClass('is-invalid');
        $('#fs_name_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#flystatus_save_error').addClass('d-none');
                $('#flystatus_save_success').removeClass('d-none');
                $('#fly_status_form')[0].reset();
                var table = $('.dataflyStatus').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#add-fly-status').modal('hide');
                    $('#fly_status_form')[0].reset();
                    $('#flystatus_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#flystatus_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#flystatus_save_error').removeClass('d-none');
        $('#flystatus_save_success').addClass('d-none');
    }
});

function deleteflycondition(fs_id){
    var fs_id = fs_id;
    Swal.fire({
    title: "Are you sure you want to delete this fly condition?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
        $.ajax({
            type: "POST",
            url: "requested-fly-status/delete", 
            data: {fs_id:fs_id},
            success: function(data) {
                Swal.fire({
                            icon: "success",
                            title: "Deleted!",
                            text: "Fly condition details has been deleted.",
                            confirmButtonClass: "btn btn-success",
                          });
                                var table = $('.dataflyStatus').DataTable();
                                table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}