$(document).ready(function(){
	getNewsEventData();
});
function getNewsEventData(){
	if($('.datanewseventnew').length > 0) {
	$('.datanewseventnew').DataTable({
			"bFilter": true,
			"sDom": 'fBtlpi',  
			"ordering": true,
			"language": {
				search: ' ',
				sLengthMenu: '_MENU_',
				searchPlaceholder: "Search",
				info: "_START_ - _END_ of _TOTAL_ items",
				paginate: {
					next: ' <i class=" fa fa-angle-right"></i>',
					previous: '<i class="fa fa-angle-left"></i> '
				},
			 },
		 "ajax": {
      "url": "event/get", 
      "type": "GET", 
      "dataSrc": "" 
  		},
    	"columns": [
        { "data": "n_title" },
        { "data": "e_title" },
        { "data": "e_date" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.n_id}' onclick='editNewsEvent(${row.n_id})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.n_id}' onclick='deleteNewsEvent(${row.n_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
			initComplete: (settings, json)=>{
				$('.dataTables_filter').appendTo('#tableSearch');
				$('.dataTables_filter').appendTo('.search-input');

			},	
		});
	}
}
function editNewsEvent(n_id){	
	$.ajax({
            type: "GET",
            url: "event/getById/"+n_id,
            dataType: 'json',
            success: function(data) { 
                $('#n_id').val(data.n_id);
                $('#n_title1').val(data.n_title);
        		$('#n_content1').val(data.n_content);
        		$('#e_title1').val(data.e_title);
                $('#e_date1').val(data.e_date);
                $('#e_description1').val(data.e_description);
                if(data.n_image != ''){
                   $('#n_image2').html(data.n_image); 
                } else {
                    $('#n_image2').html('No image Found');
                }
                $('#edit-news').modal('show');
            },
            error: function(xhr, status, error) {
                $('#group1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$(document).ready(function() {
    $("#newsevent_edit_form").submit(function(e) {
        e.preventDefault(); // Prevent default form submission

    var n_title = $('#n_title1').val();
    var n_content = $('#n_content1').val();
    var e_title = $('#e_title1').val(); 
    var e_date = $('#e_date1').val();
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (n_title.trim() === '') {
        $('#n_title1').addClass('is-invalid');
        $('#n_title1_error').removeClass('d-none');
        isValid = false;
    }

    if (n_content.trim() === '') {
        $('#n_content1').addClass('is-invalid');
        $('#n_content1_error').removeClass('d-none');
        isValid = false;
    }

    if (e_title.trim() === '') {
        $('#e_title1').addClass('is-invalid');
        $('#e_title1_error').removeClass('d-none');
        isValid = false;
    }

    if (e_date.trim() === '') {
        $('#e_date1').addClass('is-invalid');
        $('#e_date1_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var formData = new FormData(this);
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $('#newsevent1_save_error').addClass('d-none');
                $('#newsevent1_save_success').removeClass('d-none');

                var table = $('.datanewseventnew').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#edit-news').modal('hide');
                    $('#newsevent_edit_form')[0].reset();
                    $('#newsevent1_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#newsevent1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#newsevent1_save_error').removeClass('d-none');
        $('#newsevent1_save_success').addClass('d-none');
    }
    });
});


$("#newsevent_form").submit(function(e) {
    e.preventDefault(); 

    var n_title = $('#n_title').val();
    var n_content = $('#n_content').val();
    var e_title = $('#e_title').val(); 
    var e_date = $('#e_date').val();
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (n_title.trim() === '') {
        $('#n_title').addClass('is-invalid');
        $('#n_title_error').removeClass('d-none');
        isValid = false;
    }

    if (n_content.trim() === '') {
        $('#n_content').addClass('is-invalid');
        $('#n_content_error').removeClass('d-none');
        isValid = false;
    }

    if (e_title.trim() === '') {
        $('#e_title').addClass('is-invalid');
        $('#e_title_error').removeClass('d-none');
        isValid = false;
    }

    if (e_date.trim() === '') {
        $('#e_date').addClass('is-invalid');
        $('#e_date_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var formData = new FormData(this);
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $('#newsevent_save_error').addClass('d-none');
                $('#newsevent_save_success').removeClass('d-none');
                $('#newsevent_edit_form')[0].reset();
                var table = $('.datanewseventnew').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#add-event').modal('hide');
                    $('#newsevent_form')[0].reset();
                    $('#newsevent_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#newsevent_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#newsevent_save_error').removeClass('d-none');
        $('#newsevent_save_success').addClass('d-none');
    }
});

function deleteNewsEvent(n_id){
	var n_id = n_id;
	Swal.fire({
    title: "Are you sure you want to delete this news/events?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
    	$.ajax({
            type: "POST",
            url: "event/delete", 
            data: {n_id:n_id},
            success: function(data) {
                Swal.fire({
					        icon: "success",
					        title: "Deleted!",
					        text: "Events/News details has been deleted.",
					        confirmButtonClass: "btn btn-success",
					      });
								var table = $('.datanewseventnew').DataTable();
								table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}