$(document).ready(function(){
    getFlyCenterData();
});
function getFlyCenterData(){
    if($('.dataflycenter').length > 0) {
    $('.dataflycenter').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": "fly-centers/get", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
        { "data": "fc_id" },
        { "data": "fc_name" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.fc_id}' onclick='editFlyCenter(${row.fc_id})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.fc_id}' onclick='deleteFlyCenter(${row.fc_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
    }
}
function editFlyCenter(fc_id){   
    $.ajax({
            type: "GET",
            url: "fly-centers/edit/"+fc_id,
            dataType: 'json',
            success: function(data) { 
                $('#fc_id').val(data.fc_id);
                $('#fc_name1').val(data.fc_name);
                $('#edit-fly-center').modal('show');
            },
            error: function(xhr, status, error) {
                $('#flycenter_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$("#fly_center_edit_form").submit(function(e) {
    e.preventDefault(); 

    var fc_name = $('#fc_name1').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (fc_name.trim() === '') {
        $('#fc_name1').addClass('is-invalid');
        $('#fc_name1_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#flycenter_edit_error').addClass('d-none');
                $('#flycenter_edit_success').removeClass('d-none');
                var table = $('.dataflycenter').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#edit-fly-center').modal('hide');
                    $('#flycenter_edit_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#flycenter_edit_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#flycenter_save_error').removeClass('d-none');
        $('#flycenter_save_success').addClass('d-none');
    }
});


$("#fly_center_form").submit(function(e) {
    e.preventDefault(); 

    var fc_name = $('#fc_name').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (fc_name.trim() === '') {
        $('#fc_name').addClass('is-invalid');
        $('#fc_name_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#flycenter_save_error').addClass('d-none');
                $('#flycenter_save_success').removeClass('d-none');
                $('#fly_center_form')[0].reset();
                var table = $('.dataflycenter').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#add-fly-center').modal('hide');
                    $('#fly_center_form')[0].reset();
                    $('#flycenter_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#flycenter_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#flycenter_save_error').removeClass('d-none');
        $('#flycenter_save_success').addClass('d-none');
    }
});

function deleteFlyCenter(fc_id){
    var fc_id = fc_id;
    Swal.fire({
    title: "Are you sure you want to delete this fly center?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
        $.ajax({
            type: "POST",
            url: "fly-centers/delete", 
            data: {fc_id:fc_id},
            success: function(data) {
                Swal.fire({
                            icon: "success",
                            title: "Deleted!",
                            text: "Fly Center details has been deleted.",
                            confirmButtonClass: "btn btn-success",
                          });
                                var table = $('.dataflycenter').DataTable();
                                table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}