<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>User List</h4>
								<h6>Manage Your Users</h6>
							</div>
						</div>
						<div class="page-btn">
							<a href="#" class="btn btn-added" data-bs-toggle="modal" data-bs-target="#add-units"><i data-feather="plus-circle" class="me-2"></i>Add New User</a>
						</div>
						<div class="page-btn">
							<a href="<?= base_url('user/approve'); ?>" class="btn btn-secondary rounded-pill">Aprove new users <i data-feather="arrow-right" class="me-2"></i></a>
						</div>
					</div>


					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<div class="search-path">
									<div class="d-flex align-items-center">
										<a class="btn btn-filter" id="filter_search">
											<i data-feather="filter" class="filter-icon"></i>
											<span><img src="<?= base_url('public/assets/img/icons/closes.svg');?>" alt="img"></span>
										</a>
									</div>
								</div>
								
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">										
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<select class="select" id="group_filter">
													<option value="">Choose Group</option>
													<?php foreach ($groups as $group): ?>
													<option value="<?= $group['gname'] ?>"><?= $group['gname'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="zap" class="info-img"></i>
												<select class="select" id="role_filter">
													<option value="">Choose Role</option>
													<?php foreach ($roles as $role):
													if($role['r_id'] != 6) { ?>
													<option value="<?= $role['role'] ?>"><?= $role['role'] ?></option>
													<?php } endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="col-lg-12 d-none" id="user_status_error">
								<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
									<center>Status not updated!</center>
								</div>
								<br />
							</div> 
							<div class="col-lg-12 d-none" id="user_status_success">
								<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
									<center>User activated successfully!</center>
								</div>
								<br />
							</div>
							<div class="col-lg-12 d-none" id="user_status_success_1">
								<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
									<center>User De-activated successfully!</center>
								</div>
								<br />
							</div>  
							<div class="table-responsive">
								<table class="table datanew">
									<thead>
										<tr>											
											<th>User Name</th>											
											<th>Email</th>
											<th>Role</th>											
											<th>Group</th>
											<th>Status</th>
											<th class="no-sort">Action</th>
										</tr>
									</thead>
									<tbody id="user_table">
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		<!-- Add User -->
		<div class="modal fade" id="add-units">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Add User</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form id="user_form" action="<?=base_url('user/save');?>">
									<div class="row">	
										<div class="col-lg-12 d-none" id="user_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="user_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form submitted successfully!</center>
											</div>
											<br />
										</div> 								
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>User Name</label>
												<input type="text" name="uname" id="uname" class="form-control">
												<div class="invalid-feedback d-none" id="uname_error">Please provide a username</div>
											</div>
										</div>

										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Email</label>
												<input type="email" name="uemail" id="uemail" class="form-control">
												<div class="invalid-feedback d-none" id="uemail_error">Please provide a useremail</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Password</label>
												<div class="pass-group">
													<input type="password" name="upassword" id="upassword" class="pass-input">
													<span class="fas toggle-password fa-eye-slash"></span>
													<div class="invalid-feedback d-none" id="upassword_error">Please provide a user password</div>
												</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Role</label>
												<select class="select" name="u_roll_id" id="u_roll_id">
													<option value="0">Choose</option>
													<?php foreach ($roles as $role): ?>
													<option value="<?= $role['r_id'] ?>"><?= $role['role'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="u_roll_id_error">Please choose a user role</div>
											</div>
										</div>									
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Save</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Add User -->

		<!-- Edit User -->
		<div class="modal fade" id="edit-units">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Edit User</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="<?=base_url('user/update');?>" id="user_edit_form">
									<div class="row">
										<div class="col-lg-12 d-none" id="user1_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="user1_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form updated successfully!</center>
											</div>
											<br />
										</div> 										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>User Name</label>
												<input type="hidden" id="edit_uid" name="uid">
												<input type="text" name="uname1" id="uname1" class="form-control">
												<div class="invalid-feedback d-none" id="uname1_error">Please provide a username</div>
											</div>
										</div>										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Email</label>
												<input type="email" name="uemail1" id="uemail1" class="form-control">
												<div class="invalid-feedback d-none" id="uemail1_error">Please provide a useremail</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Password</label>
												<div class="pass-group">
													<input type="password" name="upassword1" id="upassword1" class="pass-input">
													<span class="fas toggle-password fa-eye-slash"></span>
													<div class="invalid-feedback d-none" id="upassword1_error">Please provide a user password</div>
												</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Role</label>
												<select class="select" name="u_roll_id1" id="u_roll_id1">
													<option value="">Choose</option>
													<?php foreach ($roles as $role):
                                                        if($role['r_id'] != 6){

													 ?>

													<option value="<?= $role['r_id'] ?>"><?= $role['role'] ?></option>
													<?php } endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="u_roll_id1_error">Please choose a user role</div>
											</div>
										</div>									
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Submit</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Edit User -->

		<!-- View User -->
		<div class="modal fade" id="view-units">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>View User</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="<?=base_url('user/update');?>" id="user_edit_form">
									<div class="row">									
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>User Name</label>
												<input type="hidden" id="edit_uid" name="uid">
												<input type="text" name="uname1" id="uname2" class="form-control">
											</div>
										</div>										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Email</label>
												<input type="email" name="uemail1" id="uemail2" class="form-control">
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Role</label>
												<select class="select" name="u_roll_id1" id="u_roll_id2">
													<option>Choose</option>
													<?php foreach ($roles as $role): ?>
													<option value="<?= $role['r_id'] ?>"><?= $role['role'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>									
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /View User -->

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>