<?php //include 'layouts/session.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
    <style>
        .qrcode-grid {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
            margin-top: 20px;
        }

        .qrcode-item {
            width: 200px;
            text-align: center;
            padding: 10px;
            border: 1px solid #ccc;
            box-sizing: border-box;
            page-break-inside: avoid;
        }

        .qrcode-item img {
            width: 150px;
            height: 150px;
            display: block;
            margin: 0 auto 10px;
        }

        .print-btn {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            border-radius: 5px;
            margin-bottom: 20px;
            transition: background-color 0.3s;
        }

        .print-btn:hover {
            background-color: #0056b3;
        }

        @media print {
            .print-btn {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php echo view('layouts/menu.php'); ?>

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="add-item d-flex">
                        <div class="page-title">
                            <h4>QR Code List</h4>
                            <h6>Scan to open details</h6>
                        </div>
                    </div>
                </div>

                <button class="print-btn" onclick="printBarcodes()">Print QR Codes</button>

                <div class="qrcode-grid">
                    <?php foreach ($stocks as $st): ?>
                        <div class="qrcode-item">
                            <img src="<?= base_url('code128/'.$st->s_id) ?>" 
                                 alt="QR Code">
                            <div><b><?= esc($st->old_ncbs_id) ?></b></div>
                            <small><?= esc($st->title) ?></small>
                            <div><small>Scan to open</small></div>
                        </div>
                    <?php endforeach; ?>
                </div>

            </div>
        </div>
    </div>

    <?php echo view('layouts/customizer.php'); ?>
    <?php echo view('layouts/vendor-scripts.php'); ?>
    <?php echo view('layouts/footer.php'); ?>

    <script>
        function printBarcodes() {
            const images = document.querySelectorAll('.qrcode-item img');
            let loadedCount = 0;

            images.forEach(img => {
                if (img.complete) {
                    loadedCount++;
                } else {
                    img.onload = () => {
                        loadedCount++;
                        if (loadedCount === images.length) {
                            window.print();
                        }
                    };
                }
            });

            if (loadedCount === images.length) {
                window.print();
            }
        }
    </script>
</body>
</html>
