<?php

namespace App\Models;

use CodeIgniter\Model;

class FlyRequest_Model extends Model
{
    protected $table = 'flyRequest';

    protected $primaryKey = 'f_id';

    protected $allowedFields = ['f_stock_name','f_genotype','f_stock_center','f_gene_affected','f_flybase_link','f_pi_id',
                                'f_requester_id','f_fly_condition','availability','f_created_at','f_updated_on','f_status'];

    public function getAllFlyRequest($st_cat_id){
        $builder = $this->db->table('flyRequest');
        $builder->select('flyRequest.*,flyCenter.fc_name as center,users.uemail as requester_email,flyCondition.f_status as flycondition,availability.av_name as availability,DATE_FORMAT(flyRequest.f_created_at, "%d %b %Y") as created'); 
        $builder->join('flyCenter', 'flyRequest.f_stock_center = flyCenter.fc_id', 'left');
        $builder->join('users', 'flyRequest.f_requester_id = users.uid', 'left');
        $builder->join('flyCondition', 'flyRequest.f_fly_condition = flyCondition.fid', 'left');
        $builder->join('availability', 'flyRequest.availability = availability.av_id','left');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getFlyRequestById($f_id){
        $builder = $this->db->table('flyRequest');
        $builder->select('flyRequest.*,users.uemail as pi_email'); 
        $builder->join('users', 'flyRequest.f_pi_id = users.uid', 'left');
        $builder->where('flyRequest.f_id',$f_id);
        $query = $builder->get(); 
        $output = $query->getRow();
        return $output; 
    }

    public function saveExcel($data){
        $builder = $this->db->table('flyRequest');
        $f_requester_id = session()->get('uid');
        for($i = 0; $i < count($data); $i++) {
            if($i != 0){
                $stockcenterData = $data[$i][2]; 
                if($stockcenterData != ''){
                    $stockcenterresult = $this->db->table('flyCenter')->where('fc_name',$stockcenterData)->get();
                    $stockcenteroutput = $stockcenterresult->getResult();
                    if(!empty($stockcenteroutput)){
                        $f_stock_center = $stockcenteroutput[0]->fc_id;
                    } else {
                        $f_stock_center = 0;
                    }   
                }
                $piData = $data[$i][5]; 
                if($piData != ''){
                    $piresult = $this->db->table('users')->where('uname',$piData)->get();
                    $pioutput = $piresult->getResult(); 
                    if(!empty($pioutput)){
                        $f_pi_id = $pioutput[0]->uid; 
                    } else {
                        $f_pi_id = 0;
                    }    
                }
                $flyData = $data[$i][7]; 
                if($flyData != ''){
                    $flyresult = $this->db->table('flyCondition')->where('f_status',$flyData)->get();
                    $flyoutput = $flyresult->getResult(); 
                    if(!empty($flyoutput)){
                        $fly_condition = $flyoutput[0]->fid;
                    } else {
                        $fly_condition = 0;
                    }
                }
                $builder->insert([
                    'f_stock_name' => $data[$i][0] ? $data[$i][0] : '',
                    'f_genotype' => $data[$i][1] ? $data[$i][1] : '',
                    'f_stock_center' =>  $f_stock_center,
                    'f_gene_affected' => $data[$i][3] ? $data[$i][3] : '',
                    'f_flybase_link' => $data[$i][4] ? $data[$i][4] : '',
                    'f_pi_id' =>  $f_pi_id,
                    'f_requester_id' => $f_requester_id,
                    'f_fly_condition' => $fly_condition,
                    'availability' => $data[$i][8] ? $data[$i][8] : ''        
                ]);
            } 
        }
        return true;
    }

}