<?php

namespace App\Controllers;

use App\Models\FlyStatus_Model;

class RequestedFlyStatus extends BaseController
{
    protected $FlyStatusModel;
    protected $request;

    public function __construct()
    {
        $this->FlyStatusModel = new FlyStatus_Model();
        $this->request = service('request');
    }
  
    public function index()
    {
        return view('requested-flystatus');
    }

    public function get()
    {
        $data = $this->FlyStatusModel->findAll();
        echo json_encode($data);
    }

    public function edit($fs_id)
    {
        $data = $this->FlyStatusModel->where('fs_id',$fs_id)->first();
        echo json_encode($data);
    }

     public function save()
    {
        $status = $this->request->getPost();
        if($this->FlyStatusModel->save($status)){
            return true;
        } else {
            return false;
        }
    }

    public function update()
    {
        $fs_id = $this->request->getPost('fs_id');
        $status = array();
        $status['fs_name'] = $this->request->getPost('fs_name');
        if($this->FlyStatusModel->update($fs_id,$status)){
            return true;
        } else {
            return false;
        }
    }

    public function delete()
    {
        $fs_id = $this->request->getPost('fs_id');
        if($this->FlyStatusModel->delete($fs_id)){
            return true;
        } else {
            return false;
        }  
    }
   
}
