<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Role_Model;
use App\Models\Group_Model;

class Home extends BaseController
{
    protected $userModel;
    protected $roleModel;
    protected $groupModel;

    public function __construct()
    {
        $this->userModel = new User_Model();
        $this->roleModel = new Role_Model();
        $this->groupModel = new Group_Model();
        $this->request = service('request');
        $this->session = \Config\Services::session();
    }

    public function index(): string
    {
        $this->session->set([     
            'u_roll_id' => 0
        ]);
        $data['captcha'] = $this->generateRandomString(6);
        return view('login',$data);
    }

    public function register(): string
    {
        return view('register');
    }

    public function login()
    {
        $uemail = $this->request->getPost('uemail');
        $upassword = $this->request->getPost('upassword');
        $data = $this->userModel->where('uemail',$uemail)->where('upassword',$upassword)->findAll();
        $total = count($data);
        if($total > 0){
            if($data[0]['is_active'] != 1){
                echo 'inactive';die;
            }
            $role = $this->roleModel->where('r_id',$data[0]['u_roll_id'])->findAll();
            $this->session->set([
                'uname'     => $data[0]['uname'],
                'uemail'    => $data[0]['uemail'],
                'uimage'    => $data[0]['uimage'],
                'upassword' => $data[0]['upassword'],
                'u_roll_id' => $data[0]['u_roll_id'],
                'u_role'    => $role[0]['role'],
                'u_pi_group' => $data[0]['u_pi_group'],
                'uid'       => $data[0]['uid']
            ]);

            
            if($data[0]['u_roll_id'] == 1){
                echo 'pi';
            } else if($data[0]['u_roll_id'] == 6){
                echo 'admin';
            } else if($data[0]['u_roll_id'] == 2){
                echo 'student';
            } else if($data[0]['u_roll_id'] == 3){
                echo 'others';
            } else if($data[0]['u_roll_id'] == 5){
                echo 'lab-admin';
            } else {
                echo 0;
            }
        } else {
            echo false;die;
        }
    }

    public function getProfile()
    {
        $data['groups'] = $this->groupModel->findAll();
        return view('profile', $data);
    }

    public function profileUpdate()
    {
        $uid = $this->request->getPost('uid');
        $profile = $this->request->getPost();
        $file = $this->request->getFile('uimage');
        if($file != ''){
            $profile['uimage'] = $file->getClientName();
            if ($file->isValid() && !$file->hasMoved()) {
                $path = FCPATH . 'uploads/';
                $file->move($path);
            }
        }
        if($this->userModel->update($uid,$profile)){
            $data = $this->userModel->where('uid',$uid)->findAll();
            $this->session->set([
                'uname'     => $data[0]['uname'],
                'uemail'    => $data[0]['uemail'],
                'uimage'    => $data[0]['uimage'],
                'upassword' => $data[0]['upassword'],
                'u_roll_id' => $data[0]['u_roll_id'],
                'u_pi_group' => $data[0]['u_pi_group'],
                'uid'       => $data[0]['uid']
            ]);
            return true;
        } else {
            return false;
        }
    }

    public function logout(){
        $session = \Config\Services::session();
        $session->set([]);

        $session = session(); // or \Config\Services::session()

    // Destroy all session data
        $session->destroy();
        return true;
    }

    public function generateRandomString($length) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; // Possible characters (numbers + letters)
        $charactersLength = strlen($characters); // Length of the characters string
        $randomString = '';

        // Loop to create the random string
        for ($i = 0; $i < $length; $i++) {
            // Pick a random character from the $characters string
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        return $randomString;
    }
}
