<?php
$link = $_SERVER[ 'PHP_SELF' ];
$link_array = explode( '/', $link );
$page = end( $link_array );
?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Stocks List</h4>
								<h6>Manage Your stocks</h6>
							</div>
						</div>
						 <?php if (session()->get('u_roll_id') == 6) { ?>
						<div class="page-btn">
							<a href="#" class="btn btn-primary rounded-pill" data-bs-toggle="modal" data-bs-target="#assign-admin-stock"><i data-feather="plus-circle" class="me-2"></i>New Transfer</a>
						</div>
						<?php
						} 
						?>
						<?php
						if($page == 4){
						?>
						<div class="page-btn">
							<a href="<?= base_url('stock/add-stock-request'); ?>" class="btn btn-primary rounded-pill"><i data-feather="plus-circle" class="me-2"></i>Add New Stock</a>
						</div>
						<?php
						} else {
						?>
						<div class="page-btn">
							<a href="<?= base_url('stock/add-stock/'.$st_cat_id); ?>" class="btn btn-primary rounded-pill"><i data-feather="plus-circle" class="me-2"></i>Add New Stock</a>
						</div>
						<?php
						}
						?>
						<?php
						if($page == 5){
							?>
						<div class="page-btn">
							<a href="<?= base_url('stock/stock-bulk-upload'); ?>" class="btn btn-info rounded-pill">Bulk upload <i data-feather="file" class="me-2"></i></a>
						</div>
							<?php
						}
						?>
					</div>

					<input type="hidden" id="st_cat_id" value="<?=$st_cat_id;?>"/>
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<div class="bulk-option">
									<div class="page-btn">
										<a class="btn btn-outline-info" id="bulk-view"><i data-feather="eye" class="me-2"></i>Bulk View</a>
										<a class="btn btn-outline-dark" href="<?=base_url();?>stock/bulk-edit"><i data-feather="edit" class="me-2"></i>Bulk Edit</a>
										<a class="btn btn-outline-success" id="bulk-delete"><i data-feather="trash-2" class="me-2"></i>Bulk delete</a>
										<a class="btn btn-outline-danger" id="bulk-download"><i data-feather="download" class="me-2"></i>Bulk Download</a>
									</div>
								</div>
								<div class="search-path">
									<div class="d-flex align-items-center">
										<a class="btn btn-filter" id="filter_search">
											<i data-feather="filter" class="filter-icon"></i>
											<span><img src="<?= base_url('public/assets/img/icons/closes.svg');?>" alt="img"></span>
										</a>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">										
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<select class="select" id="category_filter">
													<option>Category</option>
													<?php foreach ($category as $category): ?>
													<option value="<?= $category['scat_name'] ?>"><?= $category['scat_name'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<select class="select" id="uname_filter">
													<option>PI</option>
													<?php foreach ($user as $user): ?>
													<option value="<?= $user['uname'] ?>"><?= $user['uname'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<select class="select" id="flycondition_filter">
													<option>Fly condition</option>
													<?php foreach ($flycondition as $flycondition): ?>
													<option value="<?= $flycondition['f_status'] ?>"><?= $flycondition['f_status'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<!-- <input type="text" id="availability_filter" class="form-control" placeholder="Enter Availability"> -->
												<select class="select" id="availability_filter">
													<option>Availability</option>
													<?php foreach ($availability as $avail): ?>
													<option value="<?= $avail['av_name'] ?>"><?= $avail['av_name'] ?></option>
													<?php endforeach ?>
												</select>
											</div>
										</div>
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<input type="date" id="date_filter" class="form-control" placeholder="Choose Date">
											</div>
										</div>
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="col-lg-12 d-none" id="stock_status_success">
								<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
									<center>Stock accepted!</center>
								</div>
								<br />
							</div> 
							<input type="hidden" id="editUrl" value="<?=base_url('stock/edit-stock');?>">
							<input type="hidden" id="requestEditUrl" value="<?=base_url('stock/edit-stock-request');?>">
							<input type="hidden" id="viewUrl" value="<?=base_url('stock/view-stock');?>">
							<input type="hidden" id="requestViewUrl" value="<?=base_url('stock/view-stock-request');?>">
							<div class="table-responsive">
								<table class="table datastock">
									<thead>
										<?php
										if($page == 4){
										?>
										<tr>											
											<th class="no-sort">
												<label class="checkboxs">
													<input type="checkbox" id="select-all">
													<span class="checkmarks"></span>
												</label>
											</th> 
																					
											<th>Fly Stock Name</th>
											<th>Stock Centre</th>
											<th>Date</th>
											
											<th>Fly Condition</th>
											<th>Requester Email</th>
											<th class="no-sort">Action</th>
										</tr>
										<?php
											} else {
											?>

											<tr>											
											<th class="no-sort">
												<label class="checkboxs">
													<input type="checkbox" id="select-all">
													<span class="checkmarks"></span>
												</label>
											</th> 
											<th>Stock Category</th>											
											<th>NCBS ID</th>
											<th>Old NCBS ID</th>											
											<th>Name</th>
											<th>Phenotype</th>
											<th>PI</th>
											<th>Group Name</th>
											<th>Availability</th>
											<th>Fly Condition</th>
											<th>Date</th>
											<th class="no-sort">Action</th>
										</tr>


												<?php
												}
												?>
									</thead>
									<tbody>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->


		<!-- Assign Admin to Stock -->
		<div class="modal fade" id="assign-admin-stock">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Assign Stocks To Admin</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								
									<div class="row">	
										<div class="col-lg-12 d-none" id="stock_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="stock_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form submitted successfully!</center>
											</div>
											<br />
										</div> 		
																		
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Choose Admin</label>
												<select class="select" id="admin" name="admin">
													<option value="">Choose Admin</option>
													<?php foreach ($users as $user): ?>
													<option value="<?= $user['uid'] ?>"><?= $user['uname'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="st_current_handler_error">Please choose admin</div>
											</div>
										</div>										
										
																			
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit" id="assign-stock">Save</button>
									</div>
								</fo>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Assign Admin to Stock -->



		<!-- View bulk stock -->
		<div class="modal fade" id="bulk-stock-view">
			<div class="modal-dialog modal-dialog-centered stock-adjust-modal">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>View Stock Details</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body" id="stock-bulk-view">	
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /View bulk stock -->

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>

<script>
	var items = [];

$(document).ready(function() {
    var base_url = $('#base_url').val();
    var st_cat_id = $('#st_cat_id').val();
    $.ajax({
        type: "GET",
        url: base_url+"stock/get/"+st_cat_id, 
        dataType: 'json',
        success: function(data) {
            var totalData = data.length;
            for (var i = 0; i < totalData; i++) {
                items.push(data[i]['fly_stock_name']);
                $('#searchResult').append(`<div>`+data[i]['fly_stock_name']+`</div>`);
            }  
        },
        error: function(xhr, status, error) {
            alert('An error occurred: ' + error);
        }
    });
    
    $('#productSearch').on('input', function() {
        const query = $(this).val().toLowerCase();
        $('#searchResult').empty().hide();
        if (query) {
            const filteredItems = items.filter(item => item.toLowerCase().includes(query));
            filteredItems.forEach(item => {
                $('#searchResult').append(`<div class="search-item">${item}</div>`);
            });
            if (filteredItems.length) {
                $('#searchResult').show();
            }
        }
    });
});
</script>

</body>
</html>