<?php //include 'layouts/session.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
 <?php echo view('layouts/title-meta.php'); ?>
 <?php echo view('layouts/head-css.php'); ?>
</head>
<body>
<div id="global-loader" >
<div class="whirly-loader"> </div>
</div>
	<!-- main Wrapper-->
    <div class="main-wrapper">
		<?php echo view('layouts/menu.php'); ?>

		<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>New Stock</h4>
								<h6>Create new stock</h6>
							</div>
						</div>
						<ul class="table-top-head">
							<li>
								<div class="page-btn">
									<a onclick="history.back()" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Stock</a>
								</div>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
							</li>
						</ul>
						
					</div>
					<!-- /add -->
					<form action="<?=base_url('stock/save');?>" id="stock_form">
						<div class="card">
							<div class="card-body add-product pb-0">
								<div class="accordion-card-one accordion" id="accordionExample">
									<div class="accordion-item">
										<div class="accordion-header" id="headingOne">
											<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
												<div class="addproduct-icon">
													<h5><i data-feather="info" class="add-info"></i><span>Stock Information</span></h5>
													<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
												</div>
											</div>
										</div>
										<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
										<div class="accordion-body">
											<div class="row">
												<div class="col-lg-12 d-none" id="stock_save_error">
													<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
														<center>Form should not be Empty!</center>
													</div>
													<br />
												</div> 
												<div class="col-lg-12 d-none" id="stock_save_success">
													<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
														<center>Form submitted successfully!</center>
													</div>
													<br />
												</div> 
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Stock Category</label>
														<select class="select" id="st_cat_id" name="st_cat_id" >
															<option value="">Choose Stock Category</option>
															<?php foreach ($category as $cat): ?>
															<option value="<?= $cat['scat_id'] ?>"><?= $cat['scat_name'] ?></option>
															<?php endforeach ?>
														</select>
														<div class="invalid-feedback d-none" id="st_cat_id_error">Please choose a Stock category</div>
													</div>
												</div>	
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">NCBS Id</label>
														<input type="text" class="form-control" id="ncbs_id" name="ncbs_id">
														<div class="invalid-feedback d-none" id="ncbs_id_error">Please provide a Stock NCBS Id</div>
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Title</label>
														<input type="text" class="form-control" id="title" name="title">
														<div class="invalid-feedback d-none" id="title_error">Please provide a Stock Title</div>
													</div>
												</div>
											</div>
											<div class="row">
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Barcode</label><br />
														<div class="barcode_data" style="border: 1px solid #e9edf6;height:40px;">
															<svg id="barcode_img"></svg>
														</div>
														<input type="hidden" name="barcode" id="barcode" />
														<button type="button" onclick="generatebarcodeNewStock()" class="btn btn-outline-info" id="generatebtn">Generate Barcode</button>
														<div class="invalid-feedback d-none" id="barcode_error">Please provide a Barcode</div>
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Old NCBS Id</label>
														<input type="text" class="form-control" id="old_ncbs_id" name="old_ncbs_id">
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Genotype</label>
														<input type="text" class="form-control" id="genotype" name="genotype">
														<div class="invalid-feedback d-none" id="genotype_error">
														Please provide a Genotype
														</div>
													</div>
												</div>
											</div>
											<div class="row">
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">CG Number</label>
														<input type="text" class="form-control" id="cg_number" name="cg_number">
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Visible Markers</label>
														<input type="text" class="form-control" id="visible_markers" name="visible_markers">
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Obtained by</label>
														<input type="text" class="form-control" id="obtained_by" name="obtained_by">
													</div>
												</div>
											</div>
											<div class="row">
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Generated by/Origin</label>
														<input type="text" class="form-control" id="generated_by" name="generated_by">
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Phenotype/Remarks</label>
														<input type="text" class="form-control" id="phenotype" name="phenotype">
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Publications</label>
														<input type="text" class="form-control" id="publications" name="publications">
													</div>
												</div>
											</div>
											<div class="row">						
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Chromosome Affected</label>
														<input type="text" class="form-control" id="choromosome_affected" name="choromosome_affected">
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Fly-base Link</label>
														<input type="text" class="form-control" id="fly_base_link" name="fly_base_link">
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Price</label>
														<input type="text" class="form-control" id="price" name="price">
													</div>
												</div>
											</div>
											<div class="row">
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Fly Condition</label>
														<select class="select" id="fly_condition" name="fly_condition">
															<option value="">Choose Fly Condition</option>
															<?php foreach ($flycondition as $fly): ?>
															<option value="<?= $fly['fid'] ?>"><?= $fly['f_status'] ?></option>
															<?php endforeach ?>
														</select>
														<div class="invalid-feedback d-none" id="fly_condition_error">Please choose a Fly condition</div>
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Availability</label>
														<!-- <input type="text" class="form-control" id="availability" name="availability"> -->
														<select class="select" id="availability" name="availability">
															<option value="">Choose Availability</option>
															<?php foreach ($availability as $avail): ?>
															<option value="<?= $avail['av_id'] ?>"><?= $avail['av_name'] ?></option>
															<?php endforeach ?>
														</select>
														<div class="invalid-feedback d-none" id="availability_error">Please enter Availability</div>
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Sort Order</label>
														<input type="text" class="form-control" id="sort_order" name="sort_order">
													</div>
												</div>
											</div>
											<div class="row">
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">PI</label>
														<select class="select" id="pi_id" name="pi_id">
															<option value="0">Choose PI</option>
															<?php foreach ($pis as $pidata): ?>
															<option value="<?= $pidata['uid'] ?>"><?= $pidata['uname'] ?></option>
															<?php endforeach ?>
														</select>
														<div class="invalid-feedback d-none" id="pi_error">Please choose a PI</div>
													</div>
												</div>
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">Comment</label>
														<input type="hidden" name="stock_created_by" id="stock_created_by" value="<?=session()->get('uid');?>" />
														<textarea rows="5" cols="50" type="text" class="form-control" id="comment" name="comment"></textarea>
													</div>
												</div>
											</div>										
										</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-lg-12">
							<div class="btn-addproduct mb-4">
								<button type="button" class="btn btn-cancel me-2">Cancel</button>
								<button type="submit" class="btn btn-submit">Save</button>
							</div>
						</div>
					</form>
				<!-- /add -->

			</div>
		</div>
	</div>
	<!-- end main Wrapper-->
<?php echo view('layouts/customizer.php'); ?>
<!-- JAVASCRIPT -->
<?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>
<script src="https://cdn.rawgit.com/lindell/JsBarcode/master/dist/JsBarcode.all.min.js"></script>
<script>
function generatebarcodeNewStock(){
   var code = Math.floor(Math.random() * 101);
   JsBarcode("#barcode_img", code, {
        format: "CODE128", // You can change the format here
        width: 2,
        height: 40,
        displayValue: false
    }); 
   $('#barcode_img').attr('height','37px');
   $('#generatebtn').addClass('d-none');
   $('#barcode').val(code);
}
</script>