$(document).ready(function(){
	getStockTransferData();
});
function getStockTransferData(){
	if($('.dataStockTracknew').length > 0) {
        var base_url = $('#base_url').val();
	var table = $('.dataStockTracknew').DataTable({
			"bFilter": true,
			"sDom": 'fBtlpi',  
			"ordering": true,
			"language": {
				search: ' ',
				sLengthMenu: '_MENU_',
				searchPlaceholder: "Search",
				info: "_START_ - _END_ of _TOTAL_ items",
				paginate: {
					next: ' <i class=" fa fa-angle-right"></i>',
					previous: '<i class="fa fa-angle-left"></i> '
				},
			 },
		 "ajax": {
      "url": base_url+"/stock/tracking-records/get", 
      "type": "GET", 
      "dataSrc": "" 
  		},
    	"columns": [
        { "data": "st_stock_id" },
        { "data": "uname" },   
        { "data": "st_transfer_date" },
        { "data": "st_comments" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 edit-icon p-2' onclick='viewStockTransfer(${row.st_id})' id='edit-btn-${row.st_id}'>
                          <i data-feather='eye' class='feather-eye'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
			initComplete: (settings, json)=>{
				$('.dataTables_filter').appendTo('#tableSearch');
				$('.dataTables_filter').appendTo('.search-input');

			},	
		});
		$('#stockId_filter').on('change', function() {
            table.search($(this).val()).draw();
        });
        $('#handlerName_filter').on('change', function() {
            table.search($(this).val()).draw();
        });
        $('#transferdate_filter').on('change', function() {
            var transfer_date = $(this).val(); 
            $.ajax({
                type: "POST",
                url: base_url+"stock/tracking-records/orderDate",
                data: {transfer_date: transfer_date},
                dataType: 'json',
                success: function(data) { 
                    table.search(data).draw();
                },
                error: function(xhr, status, error) {
                    $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
                }
            });
        });
	}
}
function viewStockTransfer(st_id){	
    var base_url = $('#base_url').val();
	$.ajax({
            type: "GET",
            url: base_url+"stock/getStockTransferId/"+st_id,
            dataType: 'json',
            success: function(data) {
            		$('#st_stock_id1').val(data.st_stock_id).trigger('change');
            		$('#st_current_handler1').val(data.st_current_handler).trigger('change');
            		$('#st_new_handler1').val(data.st_new_handler).trigger('change');
				    $('#st_transfer_date1').val(data.st_transfer_date);
				    $('#st_comments1').val(data.st_comments);
                    $('#view-stocktransfer').modal('show'); //
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$("#stock_transfer_form").submit(function(e) {
    e.preventDefault(); // Prevent default form submission

    var st_stock_id = $('#st_stock_id').val();
    var st_current_handler = $('#st_current_handler').val();
    var st_new_handler = $('#st_new_handler').val();
    var st_transfer_date = $('#st_transfer_date').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (st_stock_id == '') {
        $('#st_stock_id').addClass('is-invalid');
        $('#st_stock_id_error').removeClass('d-none');
        isValid = false;
    }

    if (st_current_handler == '') {
        $('#st_current_handler').addClass('is-invalid');
        $('#st_current_handler_error').removeClass('d-none');
        isValid = false;
    }

    if (st_new_handler == '') {
        $('#st_new_handler').addClass('is-invalid');
        $('#st_new_handler_error').removeClass('d-none');
        isValid = false;
    }

    if (st_transfer_date == '') {
        $('#st_transfer_date').addClass('is-invalid');
        $('#st_transfer_date_error').removeClass('d-none');
        isValid = false;
    }

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            success: function(data) { 
                $('#stocktransfer_save_error').addClass('d-none');
                $('#stocktransfer_save_success').removeClass('d-none');
                var table = $('.dataStockTracknew').DataTable();
                table.ajax.reload();
                setTimeout(function(){
                    $('#add-stocktransfer').modal('hide');
                    $('#stock_transfer_form')[0].reset();
                    $('#st_stock_id').val('').trigger('change');
                    $('#st_current_handler').val('').trigger('change');
                    $('#st_new_handler').val('').trigger('change');
                    $('#stocktransfer_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stocktransfer_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#stocktransfer_save_error').removeClass('d-none');
        $('#stocktransfer_save_success').addClass('d-none');
    }
});

