$(document).ready(function(){
    getOrderData();
});
function getOrderData(){
    if($('.datapiOrder').length > 0) {
        var base_url = $('#base_url').val();
    var table = $('.datapiOrder').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": base_url+"/order/get", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
        { "data": "o_id" },
        { "data": "uname" },   
        { "data": "stock_ordered" },
        { "data": "o_created_at" },
        { "data": "status" },
        {
          "data": null, 
          "render": function (data, type, row) {
                return `<div class='edit-delete-action'>`+
                            `<a class='me-2 edit-icon p-2' onclick='viewOrderDetails(${row.o_id})' id='edit-btn-${row.o_id}'>`+
                                `<i data-feather='eye' class='feather-eye'></i>`+
                            `</a>`+
                        `</div>`;
            },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
        $('#orderdate_filter').on('change', function() {
        var order_date = $(this).val(); 
        $.ajax({
            type: "POST",
            url: base_url+"order/orderDate",
            data: {order_date: order_date},
            dataType: 'json',
            success: function(data) { 
                table.search(data).draw();
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    });
    $('#orderstatus_filter').on('change', function() {
        var order_status = $(this).val();
        $.ajax({
            type: "POST",
            url: base_url+"order/orderStatus",
            data: {order_status: order_status},
            dataType: 'json',
            success: function(data) { 
                table.search(data.status).draw();
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    });
    }
}

function viewOrderDetails(o_id){    
    var base_url = $('#base_url').val();
    $.ajax({
          type: "GET",
          url: base_url+"order/getById/"+o_id,
          dataType: 'json',
          success: function(data) {
                $('#o_id').val(data[0].o_id);
                $('#u_id').val(data[0].uname);
                $('#stock_ordered').val(data[0].stock_ordered);
                    $('#order_status').val(data[0].order_status).trigger('change');
                    $('#assigned_to').val(data[0].assigned_to).trigger('change');
              $('#view-orderDetails').modal('show'); 
          },
          error: function(xhr, status, error) {
              $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
          }
      });
}