<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
     <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>  
<style>
.chart-container {
  width: 700px;
}
</style>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Stocks Count</h4>
								<h6>Manage Your stocks</h6>
							</div>
						</div>
						<div class="page-btn">
							<a href="<?= base_url('stock/move-stock'); ?>" class="btn btn-secondary rounded-pill">Move Stock <i data-feather="arrow-right" class="me-2"></i></a>
						</div>
						<div class="page-btn">
							<a href="<?= base_url('stock/assign'); ?>" class="btn btn-warning rounded-pill">Assign Stock <i data-feather="user" class="me-2"></i></a>
						</div>
					</div>
					<div class="row">
						<div class="col-xl-6 col-sm-12 col-6 d-flex">
							<div class="card flex-fill default-cover mb-4">
								<div class="card-body">
									<div class="dash-count das3">
										<div class="dash-counts">
											<h4 id="tcount">0</h4>
											<h5>Total Stock</h5>
										</div>
										<div class="dash-imgs">
											<i data-feather="file"></i>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xl-6 col-sm-12 col-6 d-flex">
							<div class="card flex-fill default-cover mb-4">
								<div class="card-header d-flex justify-content-between align-items-center">
									<h4 class="card-title">Stock - Category wise</h4>
								</div>
								<div class="card-body">
									<div class="chart-container">
									    <canvas id="myChart"></canvas>  
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xl-6 col-sm-12 col-6 d-flex">
							<div class="card flex-fill default-cover mb-4">
								<div class="card-header d-flex justify-content-between align-items-center">
									<h4 class="card-title">Stock - Group wise</h4>
								</div>
								<div class="card-body">
									<div class="chart-container">
									    <canvas id="myPolarAreaChart"></canvas>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xl-6 col-sm-12 col-6 d-flex">
							<div class="card flex-fill default-cover mb-4">
								<div class="card-header d-flex justify-content-between align-items-center">
									<h4 class="card-title">Stock - Fly Condition wise</h4>
								</div>
								<div class="card-body">
									<div class="chart-container">
									    <canvas id="myDonutChart"></canvas>  
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xl-6 col-sm-12 col-6 d-flex">
							<div class="card flex-fill default-cover mb-4">
								<div class="card-header d-flex justify-content-between align-items-center">
									<h4 class="card-title">Stock - Availability wise</h4>
								</div>
								<div class="card-body">
									<div class="chart-container">
									    <canvas id="myVerticalLineChart"></canvas>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xl-6 col-sm-12 col-6 d-flex">
							<div class="card flex-fill default-cover mb-4">
								<div class="card-header d-flex justify-content-between align-items-center">
									<h4 class="card-title">Stock - Date wise</h4>
								</div>
								<div class="card-body">
									<div class="chart-container">
									     <canvas id="myLineChart"></canvas>
									</div>
								</div>
							</div>
						</div>
					</div>
				<!-- Button trigger modal -->

				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>
<script>
var base_url = $('#base_url').val();
$.ajax({
    url: base_url + 'count-chart',
    type: 'GET',
    success: function(data) { 
    	var result = JSON.parse(data);
    	var tcount = result.tcount;
    	$('#tcount').html(tcount);
    	var catwise = result.catwise;
    	var datewise = result.datewise;
    	var avlwise = result.avlwise;
    	var groupwise = result.groupwise;
    	var catData = [];
    	var catLabel = [];
    	var dateData = [];
    	var dateLabel = [];
    	var avlData = [];
    	var avlLabel = [];
    	var grpData = [];
    	var grpLabel = [];
    	for(var i = 0; i < catwise.length; i++){
    		catData[i] = catwise[i]['count'];
    		catLabel[i] = catwise[i]['category'];
    	}
    	for(var i = 0; i < datewise.length; i++){
    		dateData[i] = datewise[i]['dcount'];
    		dateLabel[i] = datewise[i]['date'];
    	}
    	for(var i = 0; i < avlwise.length; i++){
    		avlData[i] = avlwise[i]['acount'];
    		avlLabel[i] = avlwise[i]['availability'];
    	}
    	for(var i = 0; i < groupwise.length; i++){
    		grpData[i] = groupwise[i]['gcount'];
    		grpLabel[i] = groupwise[i]['gname'];
    	}
    	var ctx = document.getElementById('myChart').getContext('2d');

        // Create a new Chart instance
        var myChart = new Chart(ctx, {
            type: 'bar', // Type of chart
            data: {
                labels: catLabel, // X-axis labels
                datasets: [{
                    label: 'Stock - Category wise',
                    data: catData, // Y-axis data points
                   backgroundColor: [
				      'rgba(255, 99, 132, 0.2)',     
				      'rgba(255, 205, 86, 0.2)',
				      'rgba(75, 192, 192, 0.2)',     
				      'rgba(153, 102, 255, 0.2)'
				    ],
				    borderColor: [
				      'rgb(255, 99, 132)',				      
				      'rgb(255, 205, 86)',
				      'rgb(75, 192, 192)',				      
				      'rgb(153, 102, 255)'				      
				    ],
                    borderWidth: 1 // Border width of bars
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true // Ensure the Y-axis starts at 0
                    }
                }
            }
        });

        var ctx = document.getElementById('myLineChart').getContext('2d');

        // Create a new Chart instance
        var myLineChart = new Chart(ctx, {
            type: 'line', // Type of chart
            data: {
                labels: dateLabel, // X-axis labels
                datasets: [{
                    label: 'Count',
                    data: dateData, // Y-axis data points (e.g., temperature over months)
                    fill: false, // Don't fill the area under the line
                    borderColor: 'rgba(75, 192, 192, 1)', // Line color
                    tension: 0.1, // Smoothness of the line
                    borderWidth: 2 // Line thickness
                }]
            },
            options: {
                responsive: true, // Make the chart responsive
                scales: {
                    y: {
                        beginAtZero: false, // Y-axis starts from the minimum data value
                    }
                }
            }
        });

        var ctx = document.getElementById('myVerticalLineChart').getContext('2d');

        // Create a new Chart instance
        var myVerticalLineChart = new Chart(ctx, {
            type: 'line', // Type of chart (line chart)
            data: {
                labels: avlLabel, // X-axis labels
                datasets: [{
                    label: 'Count',
                    data: avlData, // Y-axis data points (e.g., temperature over months)
                    fill: false, // Don't fill the area under the line
                    borderColor: 'rgba(75, 192, 192, 1)', // Line color
                    tension: 0.1, // Smoothness of the line
                    borderWidth: 2 // Line thickness
                }]
            },
            options: {
                responsive: true,
                // Rotate the axis so the chart becomes vertical
                indexAxis: 'y',  // This makes the X-axis vertical and the Y-axis horizontal
                scales: {
                    x: {
                        beginAtZero: true // Start the X-axis from 0
                    },
                    y: {
                        beginAtZero: true // Ensure the Y-axis starts at 0
                    }
                }
            }
        });

        var ctx = document.getElementById('myPolarAreaChart').getContext('2d');

        // Create a new Chart instance
        var myPolarAreaChart = new Chart(ctx, {
            type: 'polarArea', // Chart type: polar area chart
            data: {
                labels: grpLabel, // Labels for each section of the circle
                datasets: [{
                    label: 'Color Distribution',
                    data: grpData, // Data points corresponding to each label (values for each section)
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.2)',  // Red
                        'rgba(54, 162, 235, 0.2)',  // Blue
                        'rgba(255, 255, 0, 0.2)',   // Yellow
                        'rgba(75, 192, 192, 0.2)',  // Green
                        'rgba(153, 102, 255, 0.2)', // Purple
                        'rgba(255, 159, 64, 0.2)'   // Orange
                    ], // Background colors for each section
                    borderColor: [
                        'rgba(255, 99, 132, 1)',  // Red
                        'rgba(54, 162, 235, 1)',  // Blue
                        'rgba(255, 255, 0, 1)',   // Yellow
                        'rgba(75, 192, 192, 1)',  // Green
                        'rgba(153, 102, 255, 1)', // Purple
                        'rgba(255, 159, 64, 1)'   // Orange
                    ], // Border colors for each section
                    borderWidth: 1 // Border width around each section
                }]
            },
            options: {
                responsive: true,
                scale: {
                    ticks: {
                        beginAtZero: true // Ensure the scale starts at 0
                    }
                }
            }
        });
	   
    },
    error: function(xhr, status, error) {
        $('#user_role_error').removeClass('d-none');
    }
});
$.ajax({
    url: base_url + 'flychart',
    type: 'GET',
    success: function(data) { 
    	var result = JSON.parse(data);
    	var fly = result.fly;
    	var flyData = [];
    	for(var i = 0; i < fly.length; i++){
    		flyData[i] = fly[i]['f_status'];
    	}
    	var stock = result.stock;
    	var stockData = [];
    	for(var j = 0; j < stock.length; j++){
    		stockData[j] = stock[j]['data'];
    	}
        var ctx = document.getElementById('myDonutChart').getContext('2d');
	      
	      // Create a new Chart instance
	      var myDonutChart = new Chart(ctx, {
	        type: 'doughnut',  // Specify the chart type (donut chart)
	        data: {
	          labels: flyData,  // Labels for each section of the donut
	          datasets: [{
	            data: stockData,  // The data for each section
	            backgroundColor: ['#198754', '#33C1FF', '#ffc107','#dc3545','#d63384'],  // Colors for each section
	            borderColor: '#fff',  // Border color for each section
	            borderWidth: 2  // Border width for the sections
	          }]
	        },
	        options: {
	          responsive: true,  // Make the chart responsive to screen size
	          plugins: {
	            legend: {
	              position: 'top',  // Position of the legend
	            },
	            tooltip: {
	              callbacks: {
	                label: function(tooltipItem) {
	                  return tooltipItem.label + ": " + tooltipItem.raw;  // Show the value on hover
	                }
	              }
	            }
	          }
	        }
	      });
    },
    error: function(xhr, status, error) {
        $('#user_role_error').removeClass('d-none');
    }
});
</script>