<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Stock List</h4>
								<h6>Manage Your stocks</h6>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-4"></div>
						<div class="col-lg-4">
							<div class="col-lg-12 d-none" id="cart_save_error">
								<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
									<center>Cart should not be Empty!</center>
								</div>
								<br />
							</div> 
							<div class="col-lg-12 d-none" id="cart_save_success">
								<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
									<center>Cart added successfully!</center>
								</div>
								<br />
							</div>
						</div>
						<div class="col-lg-4"></div> 	
					</div>
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<div class="search-path">
									<div class="d-flex align-items-center">
										<a class="btn btn-filter" id="filter_search">
											<i data-feather="filter" class="filter-icon"></i>
											<span><img src="<?= base_url('public/assets/img/icons/closes.svg');?>" alt="img"></span>
										</a>
									</div>
								</div>
								
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">	
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<input type="text" clss="form-control" id="genotype_filter" placeholder="Genotype"/>
											</div>
										</div>	
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<input type="text" clss="form-control" id="availability_filter" placeholder="Availability"/>
											</div>
										</div>									
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="table-responsive">
								<table class="table datapistock">
									<thead>
										<tr>											
											<th>Id</th>											
											<th>Name</th>
											<th>Genotype</th>											
											<th>Availability</th>
											<th>Fly Condition</th>
											<th class="no-sort">Action</th>
										</tr>
									</thead>
									<tbody>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		<!-- Edit User -->
		<div class="modal fade" id="view-pi-stock">
			<div class="modal-dialog modal-dialog-centered stock-adjust-modal">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>View Stock Details</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<table class="table table-responsive">
									<tbody>
										<tr>
											<td>Fly stock title</td>
											<td id="fly_stock_name"></td>
										</tr>
										<tr>
											<td>Genotype</td>
											<td id="genotype"></td>
										</tr>
										<tr>
											<td>Phenotype/Remarks</td>
											<td id="phenotype"></td>
										</tr>
										<tr>
											<td>Generated by/Origin</td>
											<td id="generated_by"></td>
										</tr>
										<tr>
											<td>Gene Affected</td>
											<td id="gene_affected"></td>
										</tr>
										<tr>
											<td>PI Email</td>
											<td id="pi_email"></td>
										</tr>
										<tr>
											<td>Visible Markers</td>
											<td id="visible_markers"></td>
										</tr>
										<tr>
											<td>Obtained by</td>
											<td id="obtained_by"></td>
										</tr>
										<tr>
											<td>Publications</td>
											<td id="publications"></td>
										</tr>
										<tr>
											<td>Chromosome Affected</td>
											<td id="choromosome_affected"></td>
										</tr>
										<tr>
											<td>Fly-base Link</td>
											<td id="fly_base_link"></td>
										</tr>
										<tr>
											<td>Group Name</td>
											<td id="group_name"></td>
										</tr>
										<tr>
											<td>Comment</td>
											<td id="comment"></td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Edit User -->

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>