<?php

namespace App\Models;

use CodeIgniter\Model;

class Dashboard_Model extends Model
{

    public function getTotalData()
    {
        $data = array();
        $u_roll_id = session()->get('u_roll_id');
        if($u_roll_id == 6){
            $data['uCount'] = $this->db->table('users')->where('u_roll_id !=', 6)->countAllResults();
            $data['gCount'] = $this->db->table('groups')->countAllResults();
            $data['oCount'] = $this->db->table('orders')->countAllResults();
            $data['sCount'] = $this->db->table('stock')->countAllResults();
        } else {
            $g_id = $this->getUserGroups();
            $data['uCount'] = $this->db->table('userGroups')->whereIn('g_id',$g_id)->groupBy('u_id')->countAllResults();
            $data['gCount'] = count($g_id);
            $data['oCount'] = $this->db->table('orders')->countAllResults();
            $data['sCount'] = $this->db->table('stock')->countAllResults();
        }
        return $data;
    }

    public function getUserData()
    {
        $g_id = $this->getUserGroups();
        $builder = $this->db->table('users'); 
        $builder->select('users.uid,users.uname,users.uemail,roles.role,DATE_FORMAT(users.u_created_at, "%d %b %Y") as date'); 
        $builder->join('roles', 'users.u_roll_id = roles.r_id', 'left'); 
        $builder->join('userGroups','users.uid = userGroups.u_id','left');
        $builder->groupBy('users.uid');
        $builder->orderBy('users.uid','desc');
        $builder->where('users.u_roll_id !=',6);
        $builder->whereIn('userGroups.g_id',$g_id);
        $builder->limit(5);
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getGroupData()
    {
        $builder = $this->db->table('groups'); 
        $builder->select('gname,users.uname as pi,gname,count(userGroups.g_id) as members');
        $builder->join('users','groups.pi_id = users.uid','left');
        $builder->join('userGroups','groups.g_id = userGroups.g_id','left');
        $builder->orderBy('groups.g_id','desc');
        $builder->groupBy('groups.g_id','desc');
        $builder->limit(5);
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getOrderData()
    {
        $builder = $this->db->table('orders'); 
        $builder->orderBy('o_id','desc');
        $builder->limit(5);
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getPiTotalData($uid)
    {
        $data = array();
        $data['gCount'] = $this->db->table('userGroups')->where('u_id',$uid)->countAllResults();
        $data['oCount'] = $this->db->table('orders')->where('u_id',$uid)->countAllResults();
        $data['sCount'] = $this->db->table('stockTransfer')->where('st_new_handler',$uid)->countAllResults();
        return $data;
    }

    public function getFlyCondition()
    {
        $builder = $this->db->table('flyCondition'); 
        $builder->select('f_status');
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getFlyConditionPercentage()
    {
        $tscount = $this->db->table('stock')->countAllResults();
        $builder = $this->db->table('stock'); 
        $builder->select('ROUND(((count(s_id)/100)*'.$tscount.')* 100) as data'); 
        $builder->groupBy('stock.fly_condition');
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getUserGroups()
    {
        $u_id = session()->get('uid');
        $group = $this->db->table('groups')
                  ->select('g_id')
                  ->where('g_created_by', $u_id)
                  ->get()
                  ->getResult();
        for($i = 0; $i < count($group); $i++){
           $g_id[$i] = $group[$i]->g_id; 
        }
        return $g_id;
    }

}