<?php

namespace App\Controllers;

use App\Models\User_Model;
use App\Models\Group_Model;
use App\Models\UserGroups_Model;

class Group extends BaseController
{
    protected $userModel;
    protected $groupModel;
    protected $ugModel;
    protected $request;

    public function __construct()
    {
        $this->userModel = new User_Model();
        $this->groupModel = new Group_Model();
        $this->ugModel = new UserGroups_Model();
        $this->request = service('request');
    }

    public function index(): string
    {
        $data['pi'] = $this->userModel->where('u_roll_id','1')->findAll(); 
        $data['pi1'] = $this->userModel->where('u_roll_id','1')->findAll();   
        $data['members'] = $this->userModel->where('u_roll_id !=', '1')->where('u_roll_id !=', '4')->where('u_roll_id !=', '6')->where('is_approve', '1')->findAll();    
        return view('groups', $data);
    }

    public function getById($gid)
    {
        $data = $this->ugModel->getJoinedData($gid);
        return json_encode($data);
    }

    public function getAll($g_id = null)
    {
        $data = $this->groupModel->getAll($g_id = null);
        for($i = 0; $i < count($data); $i++){
            $pi_id = $data[$i]->pi_id;
            $pidata = $this->userModel->where('uid',$pi_id)->first();
            $data[$i]->pi_name = $pidata['uname'];
        }
        return json_encode($data);
    }

    public function save()
    {
        $group = $this->request->getPost();
        $group['g_created_by'] = session()->get('uid');
        $this->groupModel->save($group);
        $gid = $this->groupModel->insertID();
        if($gid) {
            $uid = explode(',',$this->request->getPost('u_ids'));
            for($i = 0; $i < count($uid); $i++){
                $ugdata = [
                    'u_id' => $uid[$i],
                    'g_id' => $gid,
                ];
                $this->ugModel->save($ugdata);
            }
            return true;
        } else {
            return false;
        }
    }

    public function update()
    {
        $gid = $this->request->getPost('g_id');
        $group = array();
        $group['gname'] = $this->request->getPost('gname');
        $group['pi_id'] = $this->request->getPost('pi_id');
        if($this->groupModel->update($gid,$group)){
            $this->ugModel->where('g_id',$gid)->delete();
            $uids = explode(',',$this->request->getPost('u_ids'));
            for($i = 0; $i < count($uids); $i++){
                $ugdata = array();
                $ugdata['g_id'] = $gid;
                $ugdata['u_id'] = $uids[$i];
                $this->ugModel->save($ugdata);
            }
        } else {
            return false;
        }
    }

    public function delete()
    {
        $gid = $this->request->getPost('g_id');
        if($this->groupModel->delete($gid)){
            $this->ugModel->where('g_id',$gid)->delete();
            return true;
        } else {
            return false;
        }  
    }

    public function pigroup()
    {
        return view('pi-group');
    }

    public function piGroupData($uid)
    {
        $data = $this->groupModel->getPiGroupData($uid);
        return json_encode($data);
    }

    public function piGroupDetails($gid)
    {
        $data['gdata'] = $this->groupModel->getAll($gid); 
        return view('pi-group-details', $data);
    }

    public function getUserList()
    {
        $data['users'] = $this->userModel->where('u_roll_id !=', '1')->findAll();  
        return json_encode($data);
    }

    public function saveUserGroup()
    {
        $uid = $this->request->getPost('uid');
        $gid = $this->request->getPost('gid');
        $data = array();
        $data['g_id'] = $gid;
        $data['u_id'] = $uid;
        $this->ugModel->save($data);
        return true;
    }

    public function deleteGroupUser()
    {
        $uid = $this->request->getPost('guid');
        $gid = $this->request->getPost('gid');
        if($this->ugModel->where('g_id',$gid)->where('u_id',$uid)->delete()){
            return true;
        } else {
            return false;
        }
    }
}
