<?php

namespace App\Controllers;

use App\Models\Communication_Model;

class Communication extends BaseController
{
    protected $communicationModel;
    protected $request;

    public function index(): string
    {
		return view('notification-setting');
    }

    public function __construct()
    {
        $this->communicationModel = new Communication_Model();
        $this->request = service('request');
    }

    public function getAll()
    {
        $u_id = session()->get('uid');
        $data = $this->communicationModel->where('u_id',$u_id)->first();
        return json_encode($data);
    }

    public function save()
    {
        $n_id = $this->request->getPost('n_id'); 
        if($n_id){
                $setting = [
                'email_not' => $this->request->getPost('email_not'),
                'whatsapp_not' => $this->request->getPost('whatsapp_not'),
                'sms_not' => $this->request->getPost('sms_not'),
                'message_template' => $this->request->getPost('message_template')
            ];
            if ($this->communicationModel->update($n_id, $setting)) {
                return true;
            } else {
                return false;
            }
        } else {
            $setting = [
                'email_not' => $this->request->getPost('email_not'),
                'whatsapp_not' => $this->request->getPost('whatsapp_not'),
                'sms_not' => $this->request->getPost('sms_not'),
                'message_template' => $this->request->getPost('message_template'),
                'u_id' => session()->get('uid')
            ];
            $this->communicationModel->save($setting);
        }
        
    }

}
