$('.getStockByCategory').on('change', function() {
    var categoryId = $(this).val();
    var base_url = $('#base_url').val();
    $.ajax({
        type: "POST",
        url: base_url+'stock/getStockByCategory',
        data: {'st_cat_id': categoryId},
        success: function(data) {
            $('#allStocks').html(``);
            var result = JSON.parse(data);
            for(var i = 0; i < result.length; i++){
                $('#allStocks').append(`<tr>`+
                                        `<td>`+
                                            `<label class="checkboxs">`+
                                                `<input type="checkbox" name="s_id[]" value="`+result[i].s_id+`">`+
                                                `<span class="checkmarks"></span>`+
                                            `</label>`+
                                        `</td>`+
                                        `<td>`+result[i].title+`</td>`+
                                    `</tr>`);
            }  
        },
        error: function(xhr, status, error) {
            $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
        }
    });
});

$("#move-stock-form").submit(function(e) {
    var st_cat_id_old = $('#st_cat_id_old').val();
    var st_cat_id_new = $('#st_cat_id_new').val();
    var stock_list_ids = $('.stock_list:checked').map(function() {
        return this.id;
    }).get();
    if(st_cat_id_old == ''){
        e.preventDefault(); 
        $('#st_cat_id_old_error').removeClass('d-none');
    } else {
        $('#st_cat_id_old_error').addClass('d-none');
    }
    if(st_cat_id_new == ''){
        e.preventDefault(); 
        $('#st_cat_id_new_error').removeClass('d-none');
    } else {
        $('#st_cat_id_new_error').addClass('d-none');
    }
    if(stock_list_ids == ''){
        e.preventDefault(); 
        $('#stock_list_ids_error').removeClass('d-none');
    } else {
        $('#stock_list_ids_error').addClass('d-none');
    }
    if(st_cat_id_old != '' && st_cat_id_new != '') {
        e.preventDefault(); 
        var form = $(this);
        var base_url = $('#base_url').val();   
        $.ajax({
            type: "POST",
            url: base_url+'stock/assign-stock',
            data: form.serialize(),
            success: function(data) {
                $('#stockassign_save_success').removeClass('d-none');
                $('#st_cat_id_old_error').addClass('d-none');
                $('#st_cat_id_new_error').addClass('d-none');
                $('#stock_list_ids_error').addClass('d-none');
                setTimeout(function(){  
                    window.location.reload();   
                    $('#stockassign_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stockassign_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    }
});

$("#assign-stock-form").submit(function(e) {
    e.preventDefault(); 
    var form = $(this);
    var base_url = $('#base_url').val(); 
    var assign_user_id = $('#assign_user_id').val();
    var assign_stock_id = $('.assign_stock_id:checked').map(function() {
        return this.id;
    }).get(); 
    if(assign_user_id == ''){
        e.preventDefault(); 
        $('#assign_user_id_error').removeClass('d-none');
    } else {
        $('#assign_user_id_error').addClass('d-none');
    }
    if(assign_stock_id == ''){
        e.preventDefault(); 
        $('#assign_stock_id_error').removeClass('d-none');
    } else {
        $('#assign_stock_id_error').addClass('d-none');
    } 
    if(assign_user_id != '') {
        $.ajax({
            type: "POST",
            url: base_url+'stock/assign-stock-la',
            data: form.serialize(),
            success: function(data) {
                $('#stockassignla_save_success').removeClass('d-none');
                setTimeout(function(){  
                    window.location.reload();   
                    $('#stockassignla_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#stockassign_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    }
});