<?php

namespace App\Models;

use CodeIgniter\Model;

class Stock_Model extends Model
{
    protected $table = 'stock';

    protected $primaryKey = 's_id';

    protected $allowedFields = ['s_id','st_cat_id','ncbs_id','title', 'barcode', 'old_ncbs_id', 'genotype', 'cg_number', 
                                'visible_markers','obtained_by','generated_by','phenotype','publications',
                                'choromosome_affected','fly_base_link','price','fly_condition','availability','sort_order','comment','stock_created_by','s_created_at','s_updated_on','pi_id','is_active'];

    public function saveExcel($data){
        $builder = $this->db->table('stock');
        for($i = 0; $i < count($data); $i++) {
            if($i != 0){
                $builder->insert([
                    'st_cat_id' => $data[$i][0] ? $data[$i][0] : '',
                    'ncbs_id' => $data[$i][1] ? $data[$i][1] : '',
                    'title' => $data[$i][2] ? $data[$i][2] : '',
                    'barcode' => $data[$i][3] ? $data[$i][3] : '',
                    'old_ncbs_id' => $data[$i][4] ? $data[$i][4] : '',
                    'genotype' => $data[$i][5] ? $data[$i][5] : '',
                    'cg_number' => $data[$i][6] ? $data[$i][6] : '',
                    'phenotype' => $data[$i][7] ? $data[$i][7] : '',
                    'generated_by' => $data[$i][8] ? $data[$i][8] : '',
                    
                    'visible_markers' => $data[$i][9] ? $data[$i][9] : '',
                    'obtained_by' => $data[$i][10] ? $data[$i][10] : '',
                    
                    
                    
                    'choromosome_affected' => $data[$i][11] ? $data[$i][11] : '',
                    'publications' => $data[$i][12] ? $data[$i][12] : '',
                    'fly_base_link' => $data[$i][13] ? $data[$i][13] : '',
                    'price' => $data[$i][14] ? $data[$i][14] : '',
                    'fly_condition' => $data[$i][15] ? $data[$i][15] : '',
                    'availability' => $data[$i][16] ? $data[$i][16] : '',
                    'sort_order' => $data[$i][17] ? $data[$i][17] : '',
                    'comment' => $data[$i][18] ? $data[$i][18] : ''
                ]);
            } 
        }
        return true;
    }

    public function saveStockExcel($data){
        $builder = $this->db->table('stock');
        for($i = 0; $i < count($data); $i++) {
            if($i != 0){
                $builder->insert([
                    'st_cat_id' => 4,
                    'title' => $data[$i][1] ? $data[$i][1] : '',
                    'genotype' => $data[$i][2] ? $data[$i][2] : '',
                    'phenotype' => $data[$i][3] ? $data[$i][3] : '',
                    'generated_by' => $data[$i][4] ? $data[$i][4] : '', 
                    'gene_affected' => $data[$i][5] ? $data[$i][5] : '',
                    'pi_email' => $data[$i][6] ? $data[$i][6] : '',
                    'visible_markers' => $data[$i][7] ? $data[$i][7] : '',
                    'obtained_by' => $data[$i][8] ? $data[$i][8] : '',
                    'publications' => $data[$i][9] ? $data[$i][9] : '',
                    'choromosome_affected' => $data[$i][10] ? $data[$i][10] : '',
                    'fly_base_link' => $data[$i][11] ? $data[$i][11] : '',
                    'comment' => $data[$i][12] ? $data[$i][12] : ''
                ]);
            } 
        }
        return true;
    }

    public function updateExcel($data){
        $builder = $this->db->table('stock');
        for($i = 0; $i < count($data); $i++) {
            if($i != 0){
                $s_id = $data[$i][0];
                $piData = $data[$i][2];
                if($piData != ''){
                    $piresult = $this->db->table('users')->where('uname',$piData)->get();
                    $pioutput = $piresult->getResult();
                    $pi_id = $pioutput[0]->uid;
                }
                $catData = $data[$i][1];
                if($catData != ''){
                    $catresult = $this->db->table('stockCategory')->where('scat_name',$catData)->get();
                    $catoutput = $catresult->getResult();
                    $st_cat_id = $catoutput[0]->scat_id;
                }
                $flyData = $data[$i][17];
                if($flyData != ''){
                    $flyresult = $this->db->table('flyCondition')->where('f_status',$flyData)->get();
                    $flyoutput = $flyresult->getResult();
                    $fly_condition = $flyoutput[0]->fid;
                }
                $update = array(
                                'st_cat_id' => $st_cat_id,
                                'pi_id' => $pi_id,
                                'ncbs_id' => $data[$i][3] ? $data[$i][3] : '',
                                'title' => $data[$i][4] ? $data[$i][4] : '',
                                'barcode' => $data[$i][5] ? $data[$i][5] : '',
                                'old_ncbs_id' => $data[$i][6] ? $data[$i][6] : '',
                                'genotype' => $data[$i][7] ? $data[$i][7] : '',
                                'cg_number' => $data[$i][8] ? $data[$i][8] : '',
                                'phenotype' => $data[$i][9] ? $data[$i][9] : '',
                                'generated_by' => $data[$i][10] ? $data[$i][10] : '',
                                'visible_markers' => $data[$i][11] ? $data[$i][11] : '',  
                                'obtained_by' => $data[$i][12] ? $data[$i][12] : '',
                                'choromosome_affected' => $data[$i][13] ? $data[$i][13] : '',                
                                'publications' => $data[$i][14] ? $data[$i][14] : '',          
                                'fly_base_link' => $data[$i][15] ? $data[$i][15] : '',
                                'price' => $data[$i][16] ? $data[$i][16] : '',
                                'fly_condition' => $fly_condition,
                                'availability' => $data[$i][18] ? $data[$i][18] : '',
                                'sort_order' => $data[$i][19] ? $data[$i][19] : '',
                                'comment' => $data[$i][20] ? $data[$i][20] : ''
                            );
                $builder->update($update, ['s_id' => $s_id]); 
            } 
        }
        return true;
    }

    public function getPiStock($pi_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.*,flyCondition.f_status as flycondition'); 
        $builder->join('stockTransfer', 'stock.s_id = stockTransfer.st_stock_id','inner');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->where('stockTransfer.st_new_handler', $pi_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getAll($st_cat_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.*,DATE_FORMAT(stock.s_created_at, "%d %b %Y") as created,stockCategory.scat_name as category,flyCondition.f_status as flycondition,users.uname,groups.gname'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->join('users', 'stock.pi_id = users.uid','left');
        $builder->join('userGroups', 'users.uid = userGroups.u_id','left');
        $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
        $builder->where('stock.st_cat_id',$st_cat_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getBulkAll($s_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.s_id,stockCategory.scat_name as category,users.uname,ncbs_id,title,barcode,old_ncbs_id,
            genotype,cg_number,phenotype,generated_by,visible_markers,obtained_by,choromosome_affected,publications,fly_base_link,
            price,flyCondition.f_status as flycondition,availability,sort_order,comment'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->join('users', 'stock.pi_id = users.uid','left');
        $builder->join('userGroups', 'users.uid = userGroups.u_id','left');
        $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
        $builder->whereIn('stock.s_id',$s_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getBulkEditAll($s_id){
        $builder = $this->db->table('stock');
        $builder->select('stock.*,DATE_FORMAT(stock.s_created_at, "%d %b %Y") as created,stockCategory.scat_name as category,flyCondition.f_status as flycondition,users.uname,groups.gname'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->join('flyCondition', 'stock.fly_condition = flyCondition.fid','left');
        $builder->join('users', 'stock.pi_id = users.uid','left');
        $builder->join('userGroups', 'users.uid = userGroups.u_id','left');
        $builder->join('groups', 'userGroups.g_id = groups.g_id','left');
        $builder->whereIn('stock.s_id',$s_id);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function stockByCategory()
    {
        $builder = $this->db->table('stock');
        $builder->select('stockCategory.scat_name as category,count(stock.s_id) as count'); 
        $builder->join('stockCategory', 'stock.st_cat_id = stockCategory.scat_id','left');
        $builder->groupBy('stock.st_cat_id');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function stockByDate()
    {
        $builder = $this->db->table('stock');
        $builder->select('DATE_FORMAT(stock.s_created_at, "%d %b %Y") as date,count(stock.s_id) as dcount'); 
        $builder->groupBy('DATE(stock.s_created_at)');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function stockByAvl()
    {
        $builder = $this->db->table('stock');
        $builder->select('availability,count(stock.s_id) as acount'); 
        $builder->groupBy('availability');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function stockByGroup()
    {
        $builder = $this->db->table('stock');
        $builder->select('gname,count(stock.s_id) as gcount'); 
        $builder->join('groups', 'stock.g_id = groups.g_id','left');
        $builder->groupBy('stock.g_id');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

    public function getStockDetails($sid)
    {
        $builder = $this->db->table('stock');
        $builder->select('stock.*,groups.gname'); 
        $builder->join('groups', 'stock.g_id = groups.g_id','left');
        $builder->where('stock.s_id',$sid);
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }
}