<?php

namespace App\Models;

use CodeIgniter\Model;

class Order_Model extends Model
{
    protected $table = 'orders';

    protected $primaryKey = 'o_id';

    protected $allowedFields = ['u_id','cart_id', 'order_status', 'o_created_at', 'o_updated_on'];

    public function getJoinedData($oid = null)
    {
        $builder = $this->db->table('orders'); 
        $builder->select('orders.o_id,users.uname,orders.cart_id as stock_ordered,orderStatus.status,orders.order_status, DATE_FORMAT(orders.o_created_at, "%d %b %Y") as o_created_at'); 
        $builder->join('users', 'users.uid = orders.u_id', 'left'); 
        $builder->join('orderStatus', 'orderStatus.os_id = orders.order_status', 'left');
        if($oid != null){
            $builder->where('orders.o_id',$oid);
        }
        $builder->groupBy('orders.o_id');
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getOrderStatus()
    {
        $builder = $this->db->table('orderStatus'); 
        $query = $builder->get(); 
        return $query->getResult(); 
    }

    public function getPiOrderData($u_id)
    {
        $builder = $this->db->table('orders'); 
        $builder->select('orders.o_id,users.uname,orders.cart_id as stock_ordered,orderStatus.status,orders.order_status, DATE_FORMAT(orders.o_created_at, "%d %b %Y") as o_created_at'); 
        $builder->join('users', 'users.uid = orders.u_id', 'left'); 
        $builder->join('orderStatus', 'orderStatus.os_id = orders.order_status', 'left');
        $builder->where('orders.u_id',$u_id);
        $builder->groupBy('orders.o_id');
        $query = $builder->get(); 
        return $query->getResult(); 
    }

}