<?php

namespace App\Controllers;

use App\Models\Permission_Model;
use App\Models\Role_Model;
use App\Models\Security_Model;

class Permission extends BaseController
{
    protected $permissionModel;
    protected $roleModel;
    protected $securityModel;
    protected $request;

    public function __construct()
    {
        $this->permissionModel = new Permission_Model();
        $this->roleModel = new Role_Model();
        $this->securityModel = new Security_Model();
        $this->request = service('request');
    }

    public function index(): string
    {
        $data['roles'] = $this->roleModel->where('r_id !=','6')->findAll();
        return view('permission',$data);
    }

    public function getAll($role_id)
    {
        $userId = session()->get('uid');
        $data = $this->permissionModel->where('user_id',$userId)->where('role_id',$role_id)->first();
        return json_encode($data);
    }

    public function save()
    {
        $permission = array();
        $permission['user_id']                      = session()->get('uid'); 
        $permission['role_id']                      = $this->request->getPost('role_id'); 
        $permission['user_create']                  = $this->request->getPost('user_create') == 'on' ? 1 : 0;
        $permission['user_edit']                    = $this->request->getPost('user_edit') == 'on' ? 1 : 0;
        $permission['user_delete']                  = $this->request->getPost('user_delete') == 'on' ? 1 : 0;
        $permission['user_allow_all']               = $this->request->getPost('user_allow_all') == 'on' ? 1 : 0;
        $permission['group_create']                 = $this->request->getPost('group_create') == 'on' ? 1 : 0;
        $permission['group_edit']                   = $this->request->getPost('group_edit') == 'on' ? 1 : 0;
        $permission['group_delete']                 = $this->request->getPost('group_delete') == 'on' ? 1 : 0;
        $permission['group_allow_all']              = $this->request->getPost('group_allow_all') == 'on' ? 1 : 0;
        $permission['notification_create']          = $this->request->getPost('notification_create') == 'on' ? 1 : 0;
        $permission['notification_allow_all']       = $this->request->getPost('notification_allow_all') == 'on' ? 1 : 0;
        $permission['stock_create']                 = $this->request->getPost('stock_create') == 'on' ? 1 : 0;
        $permission['stock_edit']                   = $this->request->getPost('stock_edit') == 'on' ? 1 : 0;
        $permission['stock_delete']                 = $this->request->getPost('stock_delete') == 'on' ? 1 : 0;
        $permission['stock_allow_all']              = $this->request->getPost('stock_allow_all') == 'on' ? 1 : 0;
        $permission['bulk_upload_create']           = $this->request->getPost('bulk_upload_create') == 'on' ? 1 : 0;
        $permission['bulk_upload_allow_all']        = $this->request->getPost('bulk_upload_allow_all') == 'on' ? 1 : 0;
        $permission['barcode_create']               = $this->request->getPost('barcode_create') == 'on' ? 1 : 0;
        $permission['barcode_delete']               = $this->request->getPost('barcode_delete') == 'on' ? 1 : 0;
        $permission['barcode_allow_all']            = $this->request->getPost('barcode_allow_all') == 'on' ? 1 : 0;
        $permission['stock_transfering_create']     = $this->request->getPost('stock_transfering_create') == 'on' ? 1 : 0;
        $permission['stock_transfering_view']       = $this->request->getPost('stock_transfering_view') == 'on' ? 1 : 0;
        $permission['stock_transfering_allow_all']  = $this->request->getPost('stock_transfering_allow_all') == 'on' ? 1 : 0;
        $permission['stock_handling_create']        = $this->request->getPost('stock_handling_create') == 'on' ? 1 : 0;
        $permission['stock_handling_allow_all']     = $this->request->getPost('stock_handling_allow_all') == 'on' ? 1 : 0;
        $permission['order_create']                 = $this->request->getPost('order_create') == 'on' ? 1 : 0;
        $permission['order_allow_all']              = $this->request->getPost('order_allow_all') == 'on' ? 1 : 0;
        $permission['website_settings_create']      = $this->request->getPost('website_settings_create') == 'on' ? 1 : 0;
        $permission['website_settings_edit']        = $this->request->getPost('website_settings_edit') == 'on' ? 1 : 0;
        $permission['website_settings_delete']      = $this->request->getPost('website_settings_delete') == 'on' ? 1 : 0;
        $permission['website_settings_allow_all']   = $this->request->getPost('website_settings_allow_all') == 'on' ? 1 : 0;
        $this->securityModel->sanitize_form_array($permission);
        $previous = $this->permissionModel->where('user_id',$permission['user_id'])->where('role_id',$permission['role_id'])->findAll();
        if(empty($previous)){
            if ($this->permissionModel->save($permission)) {
                return true;
            } else {
                return false;
            }
        } else {
            if($this->permissionModel->where('user_id',$permission['user_id'])->where('role_id',$permission['role_id'])->set($permission)->update()){
                return true;
            } else {
                return false;
            }
        }
    }

}
