<?php

namespace App\Controllers;

use App\Models\Dashboard_Model;
use App\Models\Activities_Model;
use App\Models\Notification_Model;

class Dashboard extends BaseController
{
    protected $dashboardModel;
    protected $activitiesModel;
    protected $notificationModel;

    public function __construct()
    {
        $this->dashboardModel = new Dashboard_Model();
        $this->activitiesModel = new Activities_Model();
        $this->notificationModel = new Notification_Model();
        $this->request = service('request');
    }

    public function index(): string
    {
		return view('index');
    }

    public function getAll()
    {
        $data['total'] = $this->dashboardModel->getTotalData();
        $data['users'] = $this->dashboardModel->getUserData();
        $data['groups'] = $this->dashboardModel->getGroupData();
        $data['orders'] = $this->dashboardModel->getOrderData();
        return json_encode($data);
    }

    public function piindex(): string
    {
        return view('pi-index');
    }

    public function getPiAll($uid)
    {
        $data['total'] = $this->dashboardModel->getPiTotalData($uid);
        $data['activities'] = $this->activitiesModel->where('uid',$uid)->findAll();
        return json_encode($data);
    }

    public function getFlyCondition()
    {
        $data['stock'] = $this->dashboardModel->getFlyConditionPercentage();
        $data['fly'] = $this->dashboardModel->getFlyCondition();
        return json_encode($data);
    }

    public function myIndex(): string
    {
        return view('my-index');
    }

    public function getNotification()
    {
        $data = $this->notificationModel->getlast();
        return json_encode($data);
    }

}
