<!DOCTYPE html>
<html lang="en">
<head>
 <?php echo view('layouts/title-meta.php'); ?>
 <?php echo view('layouts/head-css.php'); ?>
</head>
<body>
<div id="global-loader" >
<div class="whirly-loader"> </div>
</div>
	<!-- main Wrapper-->
    <div class="main-wrapper">
		<?php echo view('layouts/menu.php'); ?>

		<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Move Stock</h4>
								<h6>Move stock from one type to another</h6>
							</div>
						</div>	
					</div>
					<form id="move-stock-form" class="form-control">
					<div class="col-lg-12 d-none" id="stockassign_save_success">
						<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
							<center>Stock assigned successfully!</center>
						</div>
						<br />
					</div>
					<div class="col-lg-12 d-none" id="stockassign_save_error">
						<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
							<center>Stock not assigned!</center>
						</div>
						<br />
					</div>  
					<div class="row">
						<div class="col-lg-3">	
							<div class="card table-list-card">	
								<div class="card-body">
									<h5>Stocks from : </h5><br />
									<table class="table table-responsive">
										<tbody>
											<select class="form-control getStockByCategory" name="st_cat_id_old" id="st_cat_id_old">
												<option value="">Choose Category</option>
												<?php
													for($i = 0; $i < count($category); $i++){
													?>
													<option value="<?=$category[$i]['scat_id'];?>"><?=$category[$i]['scat_name'];?></option>
													<?php
													}
												?>
											</select>
										</tbody>
									</table>
									<div class="row">
										<div class="text-danger d-none" id="st_cat_id_old_error">Please choose category</div>
									</div>	
								</div>
							</div>
						</div>
						<div class="col-lg-3">
							<div class="card table-list-card">	
								<div class="card-body">
									<table class="table table-responsive">
										<thead>
											<tr>
												<td>
													<label class="checkboxs">
														<input type="checkbox" id="select-all">
														<span class="checkmarks"></span>
													</label>
												</td>
												<td>All stocks</td>
											</tr>
										</thead>
										<tbody id="allStocks">
											<?php
											for($j = 0; $j < count($stock); $j++){											
												?>
												<tr>
													<td>
														<label class="checkboxs">
															<input type="checkbox" name="s_id[]" class="stock_list[]" value="<?=$stock[$j]['s_id'];?>">
															<span class="checkmarks"></span>
														</label>
													</td>
													<td><?=$stock[$j]['title'];?></td>
												</tr>
												<?php	
											}
											?>
										</tbody>
									</table>
									<div class="row">
										<div class="text-danger d-none" id="stock_list_ids_error">Please choose stock</div>
									</div>
								</div>	
							</div>
						</div>
						<div class="col-lg-3">	
							<div class="card table-list-card">	
								<div class="card-body">
									<h5>Assign To : </h5><br />
									<table class="table table-responsive">
										<tbody>
											<select class="form-control" name="st_cat_id_new" id="st_cat_id_new">
												<option value="">Choose Category</option>
												<?php
													for($i = 0; $i < count($category); $i++){
													?>
													<option value="<?=$category[$i]['scat_id'];?>"><?=$category[$i]['scat_name'];?></option>
													<?php
													}
												?>
											</select>
										</tbody>
									</table>
									<div class="row">
										<div class="text-danger d-none" id="st_cat_id_new_error">Please choose category</div>
									</div>
								</div>	
							</div>	
						</div>
						<div class="col-lg-3">	
							<div class="card table-list-card">	
								<div class="card-body">
									<table class="table table-responsive">
										<tbody>
											<button type="submit" class="btn btn-submit">Assigned</button>
										</tbody>
									</table>
								</div>	
							</div>	
						</div>
					</div>
					<br />
					</form>
			</div>
		</div>
	</div>
	<!-- end main Wrapper-->
<?php echo view('layouts/customizer.php'); ?>
<!-- JAVASCRIPT -->
<?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>