<?php

namespace App\Models;

use CodeIgniter\Model;

class UserGroups_Model extends Model
{
    protected $table = 'userGroups';

    protected $primaryKey = 'ug_id';

    protected $allowedFields = ['u_id','g_id','ug_created_at','ug_updated_on'];

    public function getJoinedData($gid)
    {
        $builder = $this->db->table('groups'); 
        $builder->select('groups.g_id,groups.gname,groups.pi_id,GROUP_CONCAT(userGroups.u_id) as u_ids'); 
        $builder->join('userGroups', 'groups.g_id = userGroups.g_id', 'left');
        $builder->where('groups.g_id',$gid);
        $builder->groupBy('groups.g_id');
        $query = $builder->get(); 
        return $query->getRow(); 
    }

}