<?php

namespace App\Models;

use CodeIgniter\Model;

class Activities_Model extends Model
{
    protected $table = 'activities';

    protected $primaryKey = 'aid';

    protected $allowedFields = ['uid','a_data','uid_to','a_created_at','a_updated_on'];

    public function getAll(){

        $builder = $this->db->table('activities');
        $builder->select('aid,a_data,uname'); 
        $builder->join('users', 'activities.uid = users.uid','left');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

}