<?php

namespace App\Controllers;

use App\Models\Role_Model;
use App\Models\User_Model;
use App\Models\Group_Model;
use App\Models\UserGroups_Model;
use App\Models\Activities_Model;
use App\Models\Communication_Model;
use App\Models\Security_Model;

class User extends BaseController
{
    protected $roleModel;
    protected $userModel;
    protected $groupModel;
    protected $usergroupModel;
    protected $activitiesModel;
    protected $communicationModel;
    protected $securityModel;

    public function __construct()
    {
        $this->roleModel = new Role_Model();
        $this->userModel = new User_Model();
        $this->groupModel = new Group_Model();
        $this->usergroupModel = new UserGroups_Model();
        $this->activitiesModel = new Activities_Model();
        $this->communicationModel = new Communication_Model();
        $this->securityModel = new Security_Model();
        $this->request = service('request');
    }

    public function index(): string
    {
		$data['roles'] = $this->roleModel->findAll(); 
        $data['groups'] = $this->groupModel->findAll();       
        return view('users', $data);
    }

    public function getById($uid)
    {
        $data = $this->userModel->where('uid', $uid)->first();
        return json_encode($data);
    }

    public function getAll()
    {
        $approve = 1;
        $data = $this->roleModel->getJoinedData($approve);
        return json_encode($data);
    }

    public function save()
    {
        $user = $this->request->getPost();
        $this->securityModel->sanitize_form_array($user);
        $file = $this->request->getFile('uimage');
        if($file != ''){
            $user['uimage'] = $file->getClientName();
            if ($file->isValid() && !$file->hasMoved()) {
                $path = FCPATH . 'uploads/';
                $file->move($path);
            }
        }
        if($this->userModel->save($user)){
            $u_id = $this->userModel->insertID();
            if($u_id){
                $notification['u_id'] = $u_id;
                if($this->communicationModel->save($notification)){
                    return true;
                } else {
                    return false; 
                }
            }
        } else {
            return false;
        }
    }

    public function update()
    {
        $uid = $_POST['uid'];
        $user = array();
        $user['uname'] = $_POST['uname1'];
        $user['uemail'] = $_POST['uemail1'];
        $user['upassword'] = $_POST['upassword1'];
        $user['u_roll_id'] = $_POST['u_roll_id1'];
        $this->securityModel->sanitize_form_array($user);
        if($this->userModel->update($uid,$user)){
            return true;
        } else {
            return false;
        }
    }

    public function delete()
    {
        $uid = $this->securityModel->sanitize_input($_POST['uid']);
        if($this->userModel->delete($uid)){
            return true;
        } else {
            return false;
        }  
    }

    public function approveUser()
    {
        return view('approve-users');
    }

    public function changeStatus(){
        $user = array();
        $user['is_active'] = $this->securityModel->sanitize_input($this->request->getPost('is_active'));
        $uid = $this->securityModel->sanitize_input($this->request->getPost('uid'));
        if($this->userModel->update($uid,$user)){
            return true;
        } else {
            return false;
        }
    }

    public function assignRole(){
        $user = array();
        $user['u_roll_id'] = $this->securityModel->sanitize_input($this->request->getPost('u_roll_id'));
        $uid = $this->securityModel->sanitize_input($this->request->getPost('uid'));
        if($this->userModel->update($uid,$user)){
            return true;
        } else {
            return false;
        }
    }

    public function assignGroup(){
        $user = array();
        $data['g_id'] = $this->request->getPost('g_id');
        $data['u_id'] = $this->request->getPost('uid'); 
        $this->securityModel->sanitize_form_array($data);
        if($this->usergroupModel->save($data)){
            return true;
        } else {
            return false;
        }
    }

    public function getNotApprovedUser()
    {
        $approve = 0;
        $data['user'] = $this->roleModel->getJoinedData($approve);
        $data['role'] = $this->roleModel->findAll();
        $data['group'] = $this->groupModel->findAll();
        echo json_encode($data);
    }

    public function approveUserStatus(){
        $user = array();
        $user['is_approve'] = $this->securityModel->sanitize_input($this->request->getPost('is_approve'));
        $uid = $this->securityModel->sanitize_input($this->request->getPost('uid'));
        if($this->userModel->update($uid,$user)){
            $activity['uid'] = session()->get('uid');
            $activity['a_data'] = 'User status approved';
            $activity['uid_to'] = $uid;
            $this->activitiesModel->save($activity);
            return true;
        } else {
            return false;
        }
    }

    public function activities()
    {
        return view('activities');
    }

    public function getActivities()
    {
        $data = $this->activitiesModel->getAll();
        echo json_encode($data);
    }
}
