<?php

namespace App\Controllers;

use App\Models\Order_Model;
use App\Models\User_Model;
use App\Models\OrderStatus_Model;
use App\Models\Courier_Model;
use App\Models\Security_Model;

class Order extends BaseController
{
    protected $orderModel;
    protected $securityModel;

    public function __construct()
    {
        $this->orderModel = new Order_Model();
        $this->userModel = new User_Model();
        $this->osModel = new OrderStatus_Model();
        $this->courierModel = new Courier_Model();
        $this->securityModel = new Security_Model();
        $this->request = service('request');
    }

    public function index(): string
    {
		$data['orderstatus'] = $this->orderModel->getOrderStatus();
        $data['users'] = $this->userModel->findAll();
        return view('orders', $data);
    }

    public function getAll()
    {
        $data = $this->orderModel->getJoinedData($oid = null);
        return json_encode($data);
    }

    public function piOrder()
    {
        $data['orderstatus'] = $this->orderModel->getOrderStatus();
        return view('pi-order',$data);
    }

    public function getPiOrder()
    {
        $u_id = session()->get('uid');
        $data = $this->orderModel->getPiOrderData($u_id);
        return json_encode($data);
    }

    public function getById($oid)
    {
        $data = $this->orderModel->getJoinedData($oid);
        return json_encode($data);
    }

    public function update()
    {
        $oid = $this->request->getPost('o_id');
        $order = array();
        $order['order_status'] = $this->request->getPost('order_status');
        $this->securityModel->sanitize_form_array($order);
        if($this->orderModel->update($oid,$order)){
            return true;
        } else {
            return false;
        }
    }

    public function orderStatus()
    {
       $order_status = $this->request->getPost('order_status'); 
       $data = $this->osModel->where('os_id',$order_status)->first();
       return json_encode($data);
    }

    public function orderDate()
    {
       $order_date = $this->request->getPost('order_date'); 
       $formattedDate = date('d M Y', strtotime($order_date));
       return json_encode($formattedDate);
    }

    public function addCourier()
    {
        $cd_id = $this->request->getPost('cd_id');
        $courier = array();
        $courier['order_id'] = $this->request->getPost('order_id');
        $courier['cd_name'] = $this->request->getPost('cd_name');
        $courier['cd_tracking_no'] = $this->request->getPost('cd_tracking_no');
        $courier['cd_tracking_url'] = $this->request->getPost('cd_tracking_url');
        $courier['cd_date_of_dispatch'] = $this->request->getPost('cd_date_of_dispatch');
        $this->securityModel->sanitize_form_array($courier);
        if($cd_id > 0){
            if($this->courierModel->update($cd_id,$courier)){
                return true;
            } else {
                return false;
            }
        } else {
            if($this->courierModel->save($courier)){
                return true;
            } else {
                return false;
            }
        }
    }

    public function getCourierDetails($o_id)
    {
        $data = $this->courierModel->where('order_id',$o_id)->findAll();
        return json_encode($data);
    }

    public function myOrder()
    {
        $data['orderstatus'] = $this->orderModel->getOrderStatus();
        return view('my-order',$data);
    }
}
