<?php //include 'layouts/session.php';?>
<!DOCTYPE html>
<html lang = 'en'>
<head>
    <?php echo view('layouts/title-meta.php'); ?>
    <?php echo view('layouts/head-css.php'); ?>
</head>
<body>

    <div id = 'global-loader' >
        <div class = 'whirly-loader'> </div>
    </div>

		<!-- Main Wrapper -->
        <div class="main-wrapper">
			
        	<?php echo view('layouts/menu.php'); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Stock Categores List</h4>
								<h6>Manage Your stock categories</h6>
							</div>
						</div>
						<div class="page-btn">
							<a href="#" class="btn btn-added" data-bs-toggle="modal" data-bs-target="#add-stock-category"><i data-feather="plus-circle" class="me-2"></i>Add new stock category</a>
						</div>
					</div>


					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
							</div>
							
							<div class="table-responsive">
								<table class="table datastockCategory">
									<thead>
										<tr>									
											<th>Stock Category Name</th>											
											<th>Centers</th>
											<th>Fly Conditions</th>											
											<th>Order Status</th>
											<th class="no-sort">Action</th>
										</tr>
									</thead>
									<tbody>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		<!-- Add stock category -->
		<div class="modal fade" id="add-stock-category">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Add Stock Category</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form id="stock_category_form" action="<?=base_url('stock-category/save');?>">
									<div class="row">	
										<div class="col-lg-12 d-none" id="stock_category_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="stock_category_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form submitted successfully!</center>
											</div>
											<br />
										</div>								
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Stock Category Name</label>
												<input type="text" name="scat_name" id="scat_name" class="form-control">
												<div class="invalid-feedback d-none" id="scat_name_error">Please provide a stock category</div>
											</div>
										</div>

										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Centers</label>
												<input type="text" name="scat_centers" id="scat_centers" class="form-control">
												<div class="invalid-feedback d-none" id="scat_centers_error">Please provide a Stock Centers</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Fly Conditions</label>
												<div class="pass-group">
													<select class="select" name="scat_fly_conditions" id="scat_fly_conditions">
														<option value="0">Choose</option>
														<?php foreach ($flycondition as $fly): ?>
														<option value="<?= $fly['fid'] ?>"><?= $fly['f_status'] ?></option>
														<?php endforeach ?>
													</select>
													<span class="fas toggle-password fa-eye-slash"></span>
													<div class="invalid-feedback d-none" id="scat_fly_conditions_error">Please provide a stock fly conditions</div>
												</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Order status</label>
												<select class="select" name="scat_ord_status" id="scat_ord_status">
													<option value="0">Choose</option>
													<?php foreach ($orderstatus as $status): ?>
													<option value="<?= $status['os_id'] ?>"><?= $status['status'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="scat_ord_status_error">Please choose a order status</div>
											</div>
										</div>									
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Save</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Add stock category -->

		<!-- Edit User -->
		<div class="modal fade" id="edit-stock-category">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Edit Stock Category</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="<?=base_url('stock-category/update');?>" id="stock_category_edit_form">
									<div class="row">
										<div class="col-lg-12 d-none" id="stockcategory1_save_error">
											<div class="alert alert-outline-danger rounded-pill alert-dismissible fade show">
												<center>Form should not be Empty!</center>
											</div>
											<br />
										</div> 
										<div class="col-lg-12 d-none" id="stockcategory1_save_success">
											<div class="alert alert-outline-success rounded-pill alert-dismissible fade show">
												<center>Form updated successfully!</center>
											</div>
											<br />
										</div> 												
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Stock Category Name</label>
												<input type="hidden" id="scat_id" name="scat_id">
												<input type="text" name="scat_name1" id="scat_name1" class="form-control">
												<div class="invalid-feedback d-none" id="scat_name_error1">Please provide a stock category name</div>
											</div>
										</div>										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Centers</label>
												<input type="text" name="scat_centers1" id="scat_centers1" class="form-control">
												<div class="invalid-feedback d-none" id="scat_centers_error1">Please provide a center</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Fly conditions</label>
												<div class="pass-group">
													<select class="select" name="scat_fly_conditions1" id="scat_fly_conditions1">
														<option value="0">Choose</option>
														<?php foreach ($flycondition as $fly): ?>
														<option value="<?= $fly['fid'] ?>"><?= $fly['f_status'] ?></option>
														<?php endforeach ?>
													</select>
													<span class="fas toggle-password fa-eye-slash"></span>
													<div class="invalid-feedback d-none" id="scat_fly_conditions_error1">Please provide a Fly conditions</div>
												</div>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Order Status</label>
												<select class="select" name="scat_ord_status1" id="scat_ord_status1">
													<option value="">Choose</option>
													<?php foreach ($orderstatus as $status): ?>
													<option value="<?= $status['os_id'] ?>"><?= $status['status'] ?></option>
													<?php endforeach ?>
												</select>
												<div class="invalid-feedback d-none" id="scat_ord_status1_error1">Please choose a Order status</div>
											</div>
										</div>									
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Submit</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Edit User -->

    <?php echo view('layouts/customizer.php'); ?>
    <!-- JAVASCRIPT -->
    <?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>