<?php

namespace App\Models;

use CodeIgniter\Model;

class Security_Model extends Model
{
   public function sanitize_input($data) {
        $data = trim($data); 
        $data = stripslashes($data);  
        $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');  
        return $data;
    }

    public function sanitize_form_array($form_array) {
        $sanitized_data = [];
        foreach ($form_array as $key => $value) {
            if (is_array($value)) {
                $sanitized_data[$key] = $this->sanitize_form_array($value);  
            } else {
                $sanitized_data[$key] = $this->sanitize_input($value);
            }
        }
        return $sanitized_data;
    }

}