<?php

namespace App\Controllers;

use PhpOffice\PhpSpreadsheet\IOFactory;

use App\Models\FlyRequest_Model;
use App\Models\User_Model;
use App\Models\Flycondition_Model;
use App\Models\FlyCenter_Model;
use App\Models\Notification_Model;

class FlyRequest extends BaseController
{
    protected $flyRequestModel;
    protected $userModel;
    protected $flyConditionModel;
    protected $flyCenterModel;
    protected $notificationModel;
    protected $request;

    public function __construct()
    {
        $this->flyRequestModel = new FlyRequest_Model();
        $this->userModel = new User_Model();
        $this->request = service('request');
        $this->flyConditionModel = new Flycondition_Model();
        $this->flyCenterModel = new FlyCenter_Model();
        $this->notificationModel = new Notification_Model();
    }
  
    public function index()
    {
        $data['center'] = $this->flyCenterModel->findAll();
        $data['user'] = $this->userModel->where('u_roll_id','1')->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['st_cat_id'] = 5;
        return view('fly-request',$data);
    }

    public function getAllFlyRequest()
    {
        $st_cat_id = 5;
        $data = $this->flyRequestModel->getAllFlyRequest($st_cat_id);
        return json_encode($data);
    }

    public function editFlyRequest($f_id)
    {
        $data['flyrequest'] = $this->flyRequestModel->getFlyRequestById($f_id);
        $data['center'] = $this->flyCenterModel->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['pis'] = $this->userModel->where('u_roll_id','1')->findAll();
        return view('edit-fly-request',$data);
    }

    public function viewFlyRequest($f_id)
    {
        $data['flyrequest'] = $this->flyRequestModel->getFlyRequestById($f_id);
        $data['center'] = $this->flyCenterModel->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        $data['pis'] = $this->userModel->where('u_roll_id','1')->findAll();
        return view('view-fly-request',$data);
    }

    public function addFlyRequest()
    {
        $data['center'] = $this->flyCenterModel->findAll();
        $data['pis'] = $this->userModel->where('u_roll_id','1')->findAll();
        $data['flycondition'] = $this->flyConditionModel->findAll();
        return view('add-fly-request',$data);
    }

    public function saveFlyRequest()
    {
        $stock = $this->request->getPost();
        if($this->flyRequestModel->save($stock)){
            $notification['message'] = 'New fly requested by '.session()->get('uid');
            $notification['n_from'] = session()->get('uid');
            $this->notificationModel->save($notification);
            return true;
        } else {
            return false;
        }
    }

    public function deleteFlyRequest()
    {
        $f_id = $this->request->getPost('f_id');
        if($this->flyRequestModel->delete($f_id)){
            return true;
        } else {
            return false;
        }  
    }

    public function updateFlyRequest()
    {
        $flyRequest = $this->request->getPost();
        $f_id = $this->request->getPost('f_id');
        if($this->flyRequestModel->update($f_id,$flyRequest)){
            $fdata = $this->flyRequestModel->where('f_id',$f_id)->first();
            $n_to = $fdata['f_requester_id'];
            $notification['n_from'] = session()->get('uid');
            $notification['message'] = 'Fly request accepted by '.session()->get('uid');
            $notification['n_to'] = $n_to;
            $this->notificationModel->save($notification);
            return true;
        } else {
            return false;
        }
    }

    public function flyRequestBulkUpload(): string
    {
        return view('fly-request-bulk-upload');
    }

    public function flyRequestBulkUploadSave()
    {
        $file = $this->request->getFile('upload');

        if ($file->isValid() && !$file->hasMoved()) {
            
            $filePath = WRITEPATH . 'uploads/' . $file->getName();
            $file->move(WRITEPATH . 'uploads/');

            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($filePath);
            $sheetData = $spreadsheet->getActiveSheet()->toArray();
            
            if($this->flyRequestModel->saveExcel($sheetData)){
                return true;
            } else{
                return false;
            }     
        }
    }
   
}
