<?php

namespace App\Controllers;

use App\Models\FlyCenter_Model;

class FlyCenter extends BaseController
{
    protected $flyCenterModel;
    protected $request;

    public function __construct()
    {
        $this->flyCenterModel = new FlyCenter_Model();
        $this->request = service('request');
    }
  
    public function index()
    {
        return view('fly-centers');
    }

    public function get()
    {
        $data = $this->flyCenterModel->findAll();
        echo json_encode($data);
    }

    public function edit($fc_id)
    {
        $data = $this->flyCenterModel->where('fc_id',$fc_id)->first();
        echo json_encode($data);
    }

     public function save()
    {
        $stock = $this->request->getPost();
        if($this->flyCenterModel->save($stock)){
            return true;
        } else {
            return false;
        }
    }

    public function update()
    {
        $fc_id = $this->request->getPost('fc_id');
        $center = array();
        $center['fc_name'] = $this->request->getPost('fc_name1');
        if($this->flyCenterModel->update($fc_id,$center)){
            return true;
        } else {
            return false;
        }
    }

    public function delete()
    {
        $fc_id = $this->request->getPost('fc_id');
        if($this->flyCenterModel->delete($fc_id)){
            return true;
        } else {
            return false;
        }  
    }
   
}
