$(document).ready(function(){
	getGroupData();
});
function getGroupData(){
	if($('.datagroupnew').length > 0) {
	$('.datagroupnew').DataTable({
			"bFilter": true,
			"sDom": 'fBtlpi',  
			"ordering": true,
			"language": {
				search: ' ',
				sLengthMenu: '_MENU_',
				searchPlaceholder: "Search",
				info: "_START_ - _END_ of _TOTAL_ items",
				paginate: {
					next: ' <i class=" fa fa-angle-right"></i>',
					previous: '<i class="fa fa-angle-left"></i> '
				},
			 },
		 "ajax": {
      "url": "group/get", 
      "type": "GET", 
      "dataSrc": "" 
  		},
    	"columns": [
        { "data": "gname" },
        { "data": "pi_name" },
        { "data": "members" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.g_id}' onclick='editGroup(${row.g_id})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.g_id}' onclick='deleteGroup(${row.g_id})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
			initComplete: (settings, json)=>{
				$('.dataTables_filter').appendTo('#tableSearch');
				$('.dataTables_filter').appendTo('.search-input');

			},	
		});
	}
}
function editGroup(gid){	
	$.ajax({
            type: "GET",
            url: "group/getById/"+gid,
            dataType: 'json',
            success: function(data) { 
        		$('#edit_gid').val(data.g_id);
        		$('#gname1').val(data.gname);
        		$('#pi_id1').val(data.pi_id).trigger('change');
                if(data.u_ids != null){
                    var uids_1 = data.u_ids.split(',');
                    $('#u_ids1').val(uids_1).trigger('change');
                }
                $('#edit-groups').modal('show');
            },
            error: function(xhr, status, error) {
                $('#group1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$(document).ready(function() {
    $("#group_edit_form").submit(function(e) {
        e.preventDefault(); 

    var g_id = $('#edit_gid').val();
    var gname = $('#gname1').val();
    var pi_id = $('#pi_id1').val();
    var u_ids = $('#u_ids1').val(); 
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (gname.trim() === '') {
        $('#gname1').addClass('is-invalid');
        $('#gname1_error').removeClass('d-none');
        isValid = false;
    }

    if (pi_id.trim() === '') {
        $('#pi_id1').addClass('is-invalid');
        $('#pi_id1_error').removeClass('d-none');
        isValid = false;
    }

    if (!u_ids || u_ids.length === 0) {
        $('#u_ids1').addClass('is-invalid');
        $('#uids1_error').removeClass('d-none');
        isValid = false;
    } 
    var input = {
        'g_id' : g_id,
        'gname': gname,
        'pi_id': pi_id,
        'u_ids': u_ids.join(',')
    };
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: input,
            success: function(data) { 
                $('#group1_save_error').addClass('d-none');
                $('#group1_save_success').removeClass('d-none');

                var table = $('.datagroupnew').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#edit-groups').modal('hide');
                    $('#group_edit_form')[0].reset();
                    $('#group1_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#group1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#group1_save_error').removeClass('d-none');
        $('#group1_save_success').addClass('d-none');
    }
    });
});


$("#group_form").submit(function(e) {
    e.preventDefault(); 

    var gname = $('#gname').val();
    var pi_id = $('#pi_id').val();
    var u_ids = $('#u_ids').val(); 
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (gname.trim() === '') {
        $('#gname').addClass('is-invalid');
        $('#gname_error').removeClass('d-none');
        isValid = false;
    }

    if (pi_id.trim() === '') {
        $('#pi_id').addClass('is-invalid');
        $('#pi_id_error').removeClass('d-none');
        isValid = false;
    }

    if (!u_ids || u_ids.length === 0) {
        $('#u_ids').addClass('is-invalid');
        $('#uids_error').removeClass('d-none');
        isValid = false;
    } 
    var input = {
        'gname': gname,
        'pi_id': pi_id,
        'u_ids': u_ids.join(',')
    };
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: input,
            success: function(data) { 
                $('#group_save_error').addClass('d-none');
                $('#group_save_success').removeClass('d-none');

                var table = $('.datagroupnew').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#add-groups').modal('hide');
                    $('#group_form')[0].reset();
                    $('#group_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#group_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#group_save_error').removeClass('d-none');
        $('#group_save_success').addClass('d-none');
    }
});

function deleteGroup(gid){
	var gid = gid;
	Swal.fire({
    title: "Are you sure you want to delete this group?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
    	$.ajax({
            type: "POST",
            url: "group/delete", 
            data: {g_id:gid},
            success: function(data) {
                Swal.fire({
					        icon: "success",
					        title: "Deleted!",
					        text: "Group details has been deleted.",
					        confirmButtonClass: "btn btn-success",
					      });
								var table = $('.datagroupnew').DataTable();
								table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}