$(document).ready(function(){
	getGroupData();
});
function getGroupData(){
	if($('.datapigroup').length > 0) {
    var uid = $('#uid').val();
	$('.datapigroup').DataTable({
		"bFilter": true,
		"sDom": 'fBtlpi',  
		"ordering": true,
		"language": {
			search: ' ',
			sLengthMenu: '_MENU_',
			searchPlaceholder: "Search",
			info: "_START_ - _END_ of _TOTAL_ items",
			paginate: {
				next: ' <i class=" fa fa-angle-right"></i>',
				previous: '<i class="fa fa-angle-left"></i> '
			},
		 },
		 "ajax": {
          "url": "pi-group/get/"+uid, 
          "type": "GET", 
          "dataSrc": "" 
  		},
    	"columns": [
                { "data": "gname" },
                { "data": "members" },
                {
                  "data": null, 
                  "render": function (data, type, row) {
                      return `<div class="page-btn">`+
                                    `<a href='pi-group-details/${row.g_id}' class="btn btn-secondary">Go to Group`+ 
                                    `<i data-feather="arrow-right" class="me-2"></i></a>`+
                                `</div>`;
                  },
                  "createdCell": function (td, cellData, rowData, row, col) {
                      $(td).addClass('action-table-data');
                  }
                }
            ],
			initComplete: (settings, json)=>{
				$('.dataTables_filter').appendTo('#tableSearch');
				$('.dataTables_filter').appendTo('.search-input');

			},	
		});
	}
}

function removeMember(guid){
    var base_url = $('#base_url').val();
    var gid = $('#gid').val();
        Swal.fire({
        title: "Are you sure you want to delete this member?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, delete it!",
        confirmButtonClass: "btn btn-success",
        cancelButtonClass: "btn btn-danger ml-1",
        buttonsStyling: false,
    }).then(function (result) {
    if (result.isConfirmed) {
        $.ajax({
            type: "POST",
            url: base_url+'group/pi-group-user-delete',
            data: {gid:gid,guid:guid},
            success: function(data) {  
               $('#guid-'+guid).remove(); 
            },
            error: function(xhr, status, error) {
                $('#user_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    }
   });   
}

function addMember(){
    var base_url = $('#base_url').val();
    var rowCount = $('#group-member-table tr').length;
    rowCount = rowCount++;
    $('#group-member').append(`<tr id="guid-`+rowCount+`">`+
                                `<td>`+
                                    `<div class="input-blocks">`+
                                        `<select class="form-control userList" name="uid" id="uid-`+rowCount+`"></select>`+
                                    `</div>`+
                                `</td>`+
                                `<td>`+
                                    `<div class="page-header">`+
                                        `<div class="page-btn" id="save-`+rowCount+`">`+
                                            `<a href="#" class="btn btn-success" onclick="saveGroupMember(`+rowCount+`)">`+
                                                `Save Member</a>`+
                                        `</div>`+
                                        `<div class="page-btn">`+
                                            `<a href="#" class="btn btn-danger" onclick="removeMember(`+rowCount+`)">`+
                                                `Remove Member</a>`+
                                        `</div>`+
                                    `</div>`+
                                `</td>`+
                            `</tr>`);
    $.ajax({
        type: "GET",
        url: base_url+'group/getUserList',
        dataType: 'json',
        success: function(data) { 
            var users = data.users;
            for(var i = 0; i < users.length; i++){ 
               $('.userList').append('<option value="'+users[i]['uid']+'">'+users[i]['uname']+'</option>'); 
            } 
        },
        error: function(xhr, status, error) {
            $('#user_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
        }
    });
}

function saveGroupMember(uId){
    var gid = $('#gid').val();
    var uid = $('#uid-'+uId).val();
    var base_url = $('#base_url').val();
    $.ajax({
        type: "POST",
        url: base_url+'group/save-member',
        data: {gid : gid,uid: uid},
        success: function(data) {
           $('#save-'+uId).remove();  
           $('#member_save_success').removeClass('d-none');
           setTimeout(function(){
               $('#member_save_success').addClass('d-none');        
            }, 3000);
        },
        error: function(xhr, status, error) {
            $('#user_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
        }
    });
}