$(document).ready(function(){
	getOrderData();
});
function getOrderData(){
	if($('.dataOrdernew').length > 0) {
        var base_url = $('#base_url').val();
	var table = $('.dataOrdernew').DataTable({
			"bFilter": true,
			"sDom": 'fBtlpi',  
			"ordering": true,
			"language": {
				search: ' ',
				sLengthMenu: '_MENU_',
				searchPlaceholder: "Search",
				info: "_START_ - _END_ of _TOTAL_ items",
				paginate: {
					next: ' <i class=" fa fa-angle-right"></i>',
					previous: '<i class="fa fa-angle-left"></i> '
				},
			 },
		 "ajax": {
      "url": base_url+"/order/get", 
      "type": "GET", 
      "dataSrc": "" 
  		},
    	"columns": [
        { "data": "o_id" },
        { "data": "uname" },   
        { "data": "stock_ordered" },
        { "data": "o_created_at" },
        { "data": "status" },
        {
          "data": null, 
          "render": function (data, type, row) {
                return `<div class='edit-delete-action'>
                            <a class='me-2 edit-icon p-2' onclick='viewOrderDetails(${row.o_id})' id='edit-btn-${row.o_id}'>
                                <i data-feather='eye' class='feather-eye'></i>
                            </a>` +
                            (row.status === 'Ready' ? 
                                `<a class='me-2 edit-icon p-2' onclick='addCourierDetails(${row.o_id})'>
                                    <i data-feather='truck' class='feather-truck'></i>
                                </a>` : 
                                '') +
                        `</div>`;
            },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
			initComplete: (settings, json)=>{
				$('.dataTables_filter').appendTo('#tableSearch');
				$('.dataTables_filter').appendTo('.search-input');

			},	
		});
		$('#orderdate_filter').on('change', function() {
        var order_date = $(this).val(); 
        $.ajax({
            type: "POST",
            url: base_url+"order/orderDate",
            data: {order_date: order_date},
            dataType: 'json',
            success: function(data) { 
                table.search(data).draw();
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    });
    $('#orderstatus_filter').on('change', function() {
        var order_status = $(this).val();
        $.ajax({
            type: "POST",
            url: base_url+"order/orderStatus",
            data: {order_status: order_status},
            dataType: 'json',
            success: function(data) { 
                table.search(data.status).draw();
            },
            error: function(xhr, status, error) {
                $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    });
	}
}

function viewOrderDetails(o_id){	
    var base_url = $('#base_url').val();
    $.ajax({
          type: "GET",
          url: base_url+"order/getById/"+o_id,
          dataType: 'json',
          success: function(data) {
          		$('#o_id').val(data[0].o_id);
          		$('#u_id').val(data[0].uname);
          		$('#stock_ordered').val(data[0].stock_ordered);
  				    $('#order_status').val(data[0].order_status).trigger('change');
  				    $('#assigned_to').val(data[0].assigned_to).trigger('change');
              $('#view-orderDetails').modal('show'); 
          },
          error: function(xhr, status, error) {
              $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
          }
      });
}

$(document).ready(function() {
    $("#order_edit_form").submit(function(e) {
        e.preventDefault(); // Prevent default form submission

        var order_status = $('#order_status').val();
        var o_id = $('#o_id').val();
        var isValid = true; 

        $('.is-invalid').removeClass('is-invalid');
        $('.error').addClass('d-none');

        var input = {
            'o_id' : o_id,
            'order_status': order_status
        };

        if (isValid) {
            var form = $(this);
            var actionUrl = form.attr('action');    
            $.ajax({
                type: "POST",
                url: actionUrl,
                data: input,
                success: function(data) {
                    $('#order_save_error').addClass('d-none');
                    $('#order_save_success').removeClass('d-none');
                    var table = $('.dataOrdernew').DataTable();
                    table.ajax.reload();
                    setTimeout(function(){
                        $('#view-orderDetails').modal('hide');
                        $('#order_edit_form')[0].reset();
                        $('.is-invalid').removeClass('is-invalid');
                        $('.error').addClass('d-none');
                        $('#order_save_success').addClass('d-none');
                    }, 2000);
                },
                error: function(xhr, status, error) {
                    $('#order_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
                }
            });
        } else {
            $('#order_save_error').removeClass('d-none');
            $('#order_save_success').addClass('d-none');
        }
    });

});

function addCourierDetails(o_id){
    $('#o_id1').val(o_id);
    var base_url = $('#base_url').val();
    $.ajax({
          type: "GET",
          url: base_url+"order/getCourierDetails/"+o_id,
          dataType: 'json',
          success: function(data) { 
            if(data.length > 0){
                $('#cd_id').val(data[0].cd_id);
                $('#cd_name').val(data[0].cd_name);
                $('#cd_tracking_no').val(data[0].cd_tracking_no);
                $('#cd_tracking_url').val(data[0].cd_tracking_url);
                $('#cd_date_of_dispatch').val(data[0].cd_date_of_dispatch);
            }
            $('#add-courierDetails').modal('show');   
          },
          error: function(xhr, status, error) {
              $('#user1_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
          }
      });
     
}

$("#order_courier_form").submit(function(e) {
    e.preventDefault(); // Prevent default form submission

    var cd_name = $('#cd_name').val();
    var o_id = $('#o_id1').val(); 
    var cd_id = $('#cd_id').val();
    var cd_tracking_no = $('#cd_tracking_no').val();
    var cd_tracking_url = $('#cd_tracking_url').val();
    var cd_date_of_dispatch = $('#cd_date_of_dispatch').val();

    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');

    var input = {
        'order_id' : o_id,
        'cd_id' : cd_id,
        'cd_name': cd_name,
        'cd_tracking_no' : cd_tracking_no,
        'cd_tracking_url' : cd_tracking_url,
        'cd_date_of_dispatch' : cd_date_of_dispatch
    };

    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');    
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: input,
            success: function(data) {
                $('#courier_save_error').addClass('d-none');
                $('#courier_save_success').removeClass('d-none');
                var table = $('.dataOrdernew').DataTable();
                table.ajax.reload();
                setTimeout(function(){
                    $('#add-courierDetails').modal('hide');
                    $('#order_courier_form')[0].reset();
                    $('.is-invalid').removeClass('is-invalid');
                    $('.error').addClass('d-none');
                    $('#courier_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#courier_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#order_save_error').removeClass('d-none');
        $('#order_save_success').addClass('d-none');
    }
});