$(document).ready(function(){
    geFlyconditionData();
});
function geFlyconditionData(){
    if($('.dataflycondition').length > 0) {
    $('.dataflycondition').DataTable({
            "bFilter": true,
            "sDom": 'fBtlpi',  
            "ordering": true,
            "language": {
                search: ' ',
                sLengthMenu: '_MENU_',
                searchPlaceholder: "Search",
                info: "_START_ - _END_ of _TOTAL_ items",
                paginate: {
                    next: ' <i class=" fa fa-angle-right"></i>',
                    previous: '<i class="fa fa-angle-left"></i> '
                },
             },
         "ajax": {
      "url": "fly-condition/get", 
      "type": "GET", 
      "dataSrc": "" 
        },
        "columns": [
        { "data": "fid" },
        { "data": "f_status" },
        {
          "data": null, 
          "render": function (data, type, row) {
              return `<div class='edit-delete-action'>
                          <a class='me-2 p-2 mb-0' id='edit-btn-${row.fid}' onclick='editflycondition(${row.fid})'>
                              <i data-feather='edit' class='feather-edit'></i>
                          </a>
                          <a class='me-2 p-2 mb-0' id='delete-btn-${row.fid}' onclick='deleteflycondition(${row.fid})' href='javascript:void(0);'>
                              <i data-feather='trash-2' class='feather-trash-2'></i>
                          </a>
                      </div>`;
          },
          "createdCell": function (td, cellData, rowData, row, col) {
              $(td).addClass('action-table-data');
          }
        }
    ],
            initComplete: (settings, json)=>{
                $('.dataTables_filter').appendTo('#tableSearch');
                $('.dataTables_filter').appendTo('.search-input');

            },  
        });
    }
}
function editflycondition(fid){   
    $.ajax({
            type: "GET",
            url: "fly-condition/edit/"+fid,
            dataType: 'json',
            success: function(data) { 
                $('#fid').val(data.fid);
                $('#f_status1').val(data.f_status);
                $('#edit-fly-condition').modal('show');
            },
            error: function(xhr, status, error) {
                $('#flycondition_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
}

$("#fly_condition_edit_form").submit(function(e) {
    e.preventDefault(); 

    var f_status = $('#f_status1').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (f_status.trim() === '') {
        $('#f_status1').addClass('is-invalid');
        $('#f_status1_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#flycondition_edit_error').addClass('d-none');
                $('#flycondition_edit_success').removeClass('d-none');
                var table = $('.dataflycondition').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#edit-fly-condition').modal('hide');
                    $('#flycondition_edit_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#flycondition_edit_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#flycondition_save_error').removeClass('d-none');
        $('#flycondition_save_success').addClass('d-none');
    }
});


$("#fly_condition_form").submit(function(e) {
    e.preventDefault(); 

    var f_status = $('#f_status').val();
    
    var isValid = true; 

    $('.is-invalid').removeClass('is-invalid');
    $('.error').addClass('d-none');
    
    if (f_status.trim() === '') {
        $('#f_status').addClass('is-invalid');
        $('#f_status_error').removeClass('d-none');
        isValid = false;
    }
   
    if (isValid) {
        var form = $(this);
        var actionUrl = form.attr('action');      
        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
           
            success: function(data) {
                $('#flycondition_save_error').addClass('d-none');
                $('#flycondition_save_success').removeClass('d-none');
                $('#fly_condition_form')[0].reset();
                var table = $('.dataflycondition').DataTable();
                table.ajax.reload();

                setTimeout(function(){
                    $('#add-fly-condition').modal('hide');
                    $('#fly_condition_form')[0].reset();
                    $('#flycondition_save_success').addClass('d-none');
                }, 2000);
            },
            error: function(xhr, status, error) {
                $('#flycondition_save_error').text('An error occurred: ' + xhr.responseText).removeClass('d-none');
            }
        });
    } else {
        $('#flycondition_save_error').removeClass('d-none');
        $('#flycondition_save_success').addClass('d-none');
    }
});

function deleteflycondition(fid){
    var fid = fid;
    Swal.fire({
    title: "Are you sure you want to delete this fly condition?",
    text: "You won't be able to revert this!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!",
    confirmButtonClass: "btn btn-success",
    cancelButtonClass: "btn btn-danger ml-1",
    buttonsStyling: false,
  }).then(function (result) {
    if (result.isConfirmed) {
        $.ajax({
            type: "POST",
            url: "fly-condition/delete", 
            data: {fid:fid},
            success: function(data) {
                Swal.fire({
                            icon: "success",
                            title: "Deleted!",
                            text: "Fly condition details has been deleted.",
                            confirmButtonClass: "btn btn-success",
                          });
                                var table = $('.dataflycondition').DataTable();
                                table.ajax.reload();               
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    }
  });
}