<?php

namespace App\Controllers;

use App\Models\Flycondition_Model;

class FlyCondition extends BaseController
{
    protected $flyConditionModel;
    protected $request;

    public function __construct()
    {
        $this->flyConditionModel = new Flycondition_Model();
        $this->request = service('request');
    }
  
    public function index()
    {
        return view('fly-condition');
    }

    public function get()
    {
        $data = $this->flyConditionModel->findAll();
        echo json_encode($data);
    }

    public function edit($fid)
    {
        $data = $this->flyConditionModel->where('fid',$fid)->first();
        echo json_encode($data);
    }

     public function save()
    {
        $status = $this->request->getPost();
        if($this->flyConditionModel->save($status)){
            return true;
        } else {
            return false;
        }
    }

    public function update()
    {
        $fid = $this->request->getPost('fid');
        $status = array();
        $status['f_status'] = $this->request->getPost('f_status');
        if($this->flyConditionModel->update($fid,$status)){
            return true;
        } else {
            return false;
        }
    }

    public function delete()
    {
        $fid = $this->request->getPost('fid');
        if($this->flyConditionModel->delete($fid)){
            return true;
        } else {
            return false;
        }  
    }
   
}
