<?php

namespace App\Controllers;

use App\Models\Dashboard_Model;
use App\Models\Activities_Model;
use App\Models\Group_Model;
use App\Models\Notification_Model;

class Dashboard extends BaseController
{
    protected $dashboardModel;
    protected $activitiesModel;
    protected $groupModel;
    protected $notificationModel;

    public function __construct()
    {
        $this->dashboardModel = new Dashboard_Model();
        $this->activitiesModel = new Activities_Model();
        $this->groupModel = new Group_Model();
        $this->notificationModel = new Notification_Model();
        $this->request = service('request');
    }

    public function index(): string
    {
		return view('index');
    }

    public function getAll()
    {
        $data['total'] = $this->dashboardModel->getTotalData();
        $data['users'] = $this->dashboardModel->getUserData();
        $data['groups'] = $this->dashboardModel->getGroupData();
        $data['orders'] = $this->dashboardModel->getOrderData();
        return json_encode($data);
    }

    public function piindex(): string
    {
        return view('pi-index');
    }

    public function getFlyConditionPi()
    {
       
         $uids = array();
     
           $pi_uid = session()->get('uid');
           $groupData = $this->groupModel->getPiGroupData($pi_uid);
        if(!empty($groupData)){
             $uids =  explode(',' ,$groupData[0]->uid);
        }else{
             $uids[] = $pi_uid; 
        }
    
       
        $data['keeping'] = $this->dashboardModel->getFlyConditionPercentagePi(3,$uids);
        $data['fly'] = $this->dashboardModel->getFlyCondition();
        return json_encode($data);
    }

    public function getPiAll($uid)
    {
        $data['total'] = $this->dashboardModel->getPiTotalData($uid);
        $data['activities'] = $this->activitiesModel->where('uid',$uid)->findAll();
        return json_encode($data);
    }

    public function getFlyCondition()
    {
        $data['common'] = $this->dashboardModel->getFlyConditionPercentage(1);
        $data['pi'] = $this->dashboardModel->getFlyConditionPercentage(2);
        $data['keeping'] = $this->dashboardModel->getFlyConditionPercentage(3);
        $data['requested'] = $this->dashboardModel->getFlyConditionPercentage(4);
        $data['fly'] = $this->dashboardModel->getFlyCondition();
        return json_encode($data);
    }

    public function myIndex(): string
    {
        return view('my-index');
    }

    public function getFlyConditionMy()
    {
         $uids = array();
       
          $uids[] =  session()->get('uid'); 

        $data['keeping'] = $this->dashboardModel->getFlyConditionPercentagePi(3,$uids);
        $data['fly'] = $this->dashboardModel->getFlyCondition();
        return json_encode($data);
    }

    public function getNotification()
    {
        $data = $this->notificationModel->getlast();
        return json_encode($data);
    }

}
