<?php //echo view('layouts/session.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
 <?php echo view('layouts/title-meta.php'); ?>
 <?php echo view('layouts/head-css.php'); ?>
 <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>  
<style>
.chart-container {
  width: 400px;
  height: 400px;
  margin: 50px auto;
}
</style>
</head>
<body>
<div id="global-loader" >
<div class="whirly-loader"> </div>
</div>
	<!-- main Wrapper-->
    <div class="main-wrapper">
    <?php echo view('layouts/menu.php'); ?>

    <div class="page-wrapper">
			<div class="content">
				<div class="row">
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-count" id="userManagement">
							<div class="dash-counts">
								<h4 id="uCount">0</h4>
								<h5>User Management</h5>
							</div>
							<div class="dash-imgs">
								<i data-feather="user"></i>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-count das1" id="groupManagement">
							<div class="dash-counts">
								<h4 id="gCount">0</h4>
								<h5>Group Management</h5>
							</div>
							<div class="dash-imgs">
								<i data-feather="user-check"></i>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-count das2" id="orderManagement">
							<div class="dash-counts">
								<h4 id="oCount">0</h4>
								<h5>Order Management</h5>
							</div>
							<div class="dash-imgs">
								<img src="<?= base_url('public/assets/img/icons/file-text-icon-01.svg');?>" class="img-fluid" alt="icon">
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-sm-6 col-12 d-flex">
						<div class="dash-count das3" id="stockManagement">
							<div class="dash-counts">
								<h4 id="sCount">0</h4>
								<h5>Stock Management</h5>
							</div>
							<div class="dash-imgs">
								<i data-feather="file"></i>
							</div>
						</div>
					</div>
				</div>
				<!-- Button trigger modal -->

				<div class="row">
					<div class="col-xl-6 col-sm-12 col-6 d-flex">
						<div class="card flex-fill default-cover mb-4">
							<div class="card-header d-flex justify-content-between align-items-center">
								<h4 class="card-title">Fly Condition</h4>
							</div>
							<div class="card-body">
								<div class="chart-container">
								    <canvas id="myDonutChart"></canvas>  
								</div>
							</div>
						</div>
					</div>
					<div class="col-xl-6 col-sm-12 col-6 d-flex">
						<div class="card flex-fill default-cover mb-4">
							<div class="card-header d-flex justify-content-between align-items-center">
								<h4 class="card-title">Recent orders</h4>
								<div class="view-all-link">
									<a href="<?=base_url('order');?>" class="view-all d-flex align-items-center">
										View All<span class="ps-2 d-flex align-items-center"><i data-feather="arrow-right" class="feather-16"></i></span>
									</a>
								</div>
							</div>
							<div class="card-body">
								<div class="table-responsive dataview">
									<table class="table dashboard-expired-products">
										<thead>
											<tr>
												<th>Order Id</th>												
												<th>User</th>
												<th>Stock</th>
												<th>Date</th>
												<th>Status</th>												
											</tr>
										</thead>
										<tbody id="recentOrders">
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xl-6 col-sm-12 col-12 d-flex">
						<div class="card flex-fill default-cover mb-4">
							<div class="card-header d-flex justify-content-between align-items-center">
								<h4 class="card-title">Recent registration</h4>
								<div class="view-all-link">
									<a href="<?=base_url('user');?>" class="view-all d-flex align-items-center">
										View All<span class="ps-2 d-flex align-items-center"><i data-feather="arrow-right" class="feather-16"></i></span>
									</a>
								</div>
							</div>
							<div class="card-body">
								<div class="table-responsive dataview">
									<table class="table dashboard-expired-products">
										<thead>
											<tr>
												<th class="no-sort">
													User Id
												</th>
												<th>User Name</th>
												<th>Email</th>
												<th>Role</th>
												<th>Date</th>												
											</tr>
										</thead>
										<tbody id="recentRegistration">
											
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
					<div class="col-xl-6 col-sm-12 col-12 d-flex">
						<div class="card flex-fill default-cover mb-4">
							<div class="card-header d-flex justify-content-between align-items-center">
								<h4 class="card-title mb-0">Recent PI Groups</h4>
								<div class="view-all-link">
									<a href="<?=base_url('group');?>" class="view-all d-flex align-items-center">
										View All<span class="ps-2 d-flex align-items-center"><i data-feather="arrow-right" class="feather-16"></i></span>
									</a>
								</div>
							</div>
							<div class="card-body">
								<div class="table-responsive dataview">
									<table class="table dashboard-recent-products">
										<thead>
											<tr>
												<th>Group Name</th>
												<th>PI</th>
												<th>Members</th>
											</tr>
										</thead>
										<tbody id="recentGroups">
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
    </div>
<!-- end main Wrapper-->
<?php echo view('layouts/customizer.php'); ?>
<!-- JAVASCRIPT -->
<?php echo view('layouts/vendor-scripts.php'); ?>
</body>
</html>
<?php echo view('layouts/footer.php'); ?>
<script>

var base_url = $('#base_url').val();
$.ajax({
    url: base_url + 'flychart',
    type: 'GET',
    success: function(data) { 
    	var result = JSON.parse(data);
    	var fly = result.fly;
    	var flyData = [];
    	for(var i = 0; i < fly.length; i++){
    		flyData[i] = fly[i]['f_status'];
    	}
    	var stock = result.stock;
    	var stockData = [];
    	for(var j = 0; j < stock.length; j++){
    		stockData[j] = stock[j]['data'];
    	}
        var ctx = document.getElementById('myDonutChart').getContext('2d');
	      
	      // Create a new Chart instance
	      var myDonutChart = new Chart(ctx, {
	        type: 'doughnut',  // Specify the chart type (donut chart)
	        data: {
	          labels: flyData,  // Labels for each section of the donut
	          datasets: [{
	            data: stockData,  // The data for each section
	            backgroundColor: ['#198754', '#33C1FF', '#ffc107','#dc3545','#d63384'],  // Colors for each section
	            borderColor: '#fff',  // Border color for each section
	            borderWidth: 2  // Border width for the sections
	          }]
	        },
	        options: {
	          responsive: true,  // Make the chart responsive to screen size
	          plugins: {
	            legend: {
	              position: 'top',  // Position of the legend
	            },
	            tooltip: {
	              callbacks: {
	                label: function(tooltipItem) {
	                  return tooltipItem.label + ": " + tooltipItem.raw;  // Show the value on hover
	                }
	              }
	            }
	          }
	        }
	      });
    },
    error: function(xhr, status, error) {
        $('#user_role_error').removeClass('d-none');
    }
});
</script>