<?php

namespace App\Models;

use CodeIgniter\Model;

class StockTransfer_Model extends Model
{
    protected $table = 'stockTransfer';

    protected $primaryKey = 'st_id';

    protected $allowedFields = ['st_stock_id', 'st_current_handler', 'st_new_handler', 'st_transfer_date', 
                                'st_comments', 'st_created_at', 'st_updated_on'];

    public function getJoinedData()
    {
        $builder = $this->db->table('stockTransfer'); 
        $builder->select('st_stock_id,uname,st_current_handler,st_comments,st_id,DATE_FORMAT(st_transfer_date, "%d %b %Y") as st_transfer_date'); 
        $builder->join('users', 'stockTransfer.st_current_handler = users.uid', 'left'); 
        $builder->groupBy('st_id');
        $query = $builder->get(); 
        return $query->getResult(); 
    }

}