<?php

namespace App\Models;

use CodeIgniter\Model;

class StockCategory_Model extends Model
{
    protected $table = 'stockCategory';

    protected $primaryKey = 'scat_id';

    protected $allowedFields = ['stock_type_id','scat_name','scat_centers','scat_fly_conditions','scat_ord_status','scat_created_at','scat_updated_on'];

    public function getStockCategory(){
        $builder = $this->db->table('stockCategory');
        $builder->select('stockCategory.*,flyCondition.f_status,orderStatus.status as status');
        $builder->join('orderStatus', 'stockCategory.scat_ord_status = orderStatus.os_id','left');
        $builder->join('flyCondition','stockCategory.scat_fly_conditions = flyCondition.fid','left');
        $query = $builder->get(); 
        $output = $query->getResult();
        return $output; 
    }

}